package cn.com.duiba.boot.ext.autoconfigure.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;

/**
 * Created by xugf on 2016/11/25
 */
@Configuration
@ConditionalOnClass({LoggerContext.class})
@ConditionalOnResource(resources="/logback/loginsight-logback.xml")
public class LoggerAutoConfiguration {
	private static final Logger logger = LoggerFactory.getLogger(LoggerAutoConfiguration.class);

	@Bean
	public ApplicationListener loggerConfiguar() {
		return new ApplicationListener<ContextRefreshedEvent>(){

			private boolean flag = true;

			@Override
			public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
				if(flag){
					try {
						LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
						JoranConfigurator configurator = new JoranConfigurator();
						configurator.setContext(loggerContext);
						//logback 添加新的配置文件
						configurator.doConfigure(new ClassPathResource("/logback/loginsight-logback.xml").getInputStream());
					} catch (Exception e) {
						logger.error(e.getMessage(), e);
					}
					flag = false;
				}
			}
		};
	}

}
