/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.dpm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class DpmFilter
implements Filter {
    private Logger LOG = LoggerFactory.getLogger(DpmFilter.class);
    private Logger DPM_LOG = LoggerFactory.getLogger((String)"dpm_log");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            String dpm = req.getParameter("dpm");
            if (dpm != null && !"".equals(dpm.trim())) {
                DpmLog log = new DpmLog();
                log.setDpm(dpm);
                Cookie[] cookies = req.getCookies();
                HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
                for (Cookie c : cookies) {
                    cookieMap.put(c.getName(), c);
                }
                Cookie _ac = (Cookie)cookieMap.get("_ac");
                if (_ac != null) {
                    String json = new String(new BASE64Decoder().decodeBuffer(_ac.getValue()), "utf-8");
                    JSONObject object = JSONObject.parseObject((String)json);
                    log.setAppId(object.getLong("aid"));
                    log.setConsumerId(object.getLong("cid"));
                }
                log.setRefererDpm(req.getParameter("referer_dpm"));
                log.setUrl(req.getRequestURL().toString());
                log.setRefererUrl(req.getHeader("referer"));
                log.setUa(req.getHeader("user-agent"));
                log.setIp(req.getRemoteHost());
                if (log.isValid()) {
                    this.DPM_LOG.info(JSON.toJSONString((Object)log));
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("DpmFilter process error,message= " + e.getMessage());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public static void main(String[] args) throws Exception {
        String s = "eyJhaWQiOjEsImNpZCI6MTUzOTM2MX0=";
        String json = new String(new BASE64Decoder().decodeBuffer(s), "utf-8");
        System.out.println(json);
    }

    public void destroy() {
    }

    private static class DpmLog {
        private Long appId;
        private Long consumerId;
        private Integer dpmType;
        private String dpm;
        private String refererDpm;
        private String url;
        private String refererUrl;
        private String ua;
        private Date time = new Date();
        private String ip;

        private DpmLog() {
        }

        public boolean isValid() {
            if (this.appId == null || this.appId <= 0L) {
                return false;
            }
            if (this.consumerId == null || this.consumerId <= 0L) {
                return false;
            }
            return this.dpm != null;
        }

        public String getDpm() {
            return this.dpm;
        }

        public void setDpm(String dpm) {
            this.dpm = dpm;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUa() {
            return this.ua;
        }

        public void setUa(String ua) {
            this.ua = ua;
        }

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public Long getConsumerId() {
            return this.consumerId;
        }

        public void setConsumerId(Long consumerId) {
            this.consumerId = consumerId;
        }

        public Integer getDpmType() {
            return this.dpmType;
        }

        public void setDpmType(Integer dpmType) {
            this.dpmType = dpmType;
        }

        public String getRefererDpm() {
            return this.refererDpm;
        }

        public void setRefererDpm(String refererDpm) {
            this.refererDpm = refererDpm;
        }

        public String getRefererUrl() {
            return this.refererUrl;
        }

        public void setRefererUrl(String refererUrl) {
            this.refererUrl = refererUrl;
        }
    }
}

