/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.logger;

import cn.com.duiba.boot.ext.autoconfigure.logger.PrintLogger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class JsonLoggerImpl
implements Logger {
    private Logger originalLogger;
    private PrintLogger printLogger;
    private Logger logger;
    private String logName;

    public JsonLoggerImpl(Class<?> key) {
        this.printLogger = new PrintLogger(key.getName());
        this.logger = this.printLogger.getLoggerInstance();
        this.originalLogger = LoggerFactory.getLogger((String)key.getName());
    }

    public JsonLoggerImpl(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.logName = name;
            StackTraceElement[] array = new Exception().getStackTrace();
            if (array.length >= 1) {
                String element = array[array.length - 1].toString();
                element = element.split("\\(")[0];
                int num = element.lastIndexOf(".");
                String className = element.substring(0, num);
                this.printLogger = new PrintLogger(className);
                this.logger = this.printLogger.getLoggerInstance();
                this.originalLogger = LoggerFactory.getLogger((String)name);
            }
        }
    }

    public String getName() {
        return StringUtils.isNotBlank((String)this.logName) ? this.logName : this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return StringUtils.isNotBlank((String)this.logName) ? this.originalLogger.isTraceEnabled() : this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return StringUtils.isNotBlank((String)this.logName) ? this.originalLogger.isDebugEnabled() : this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return StringUtils.isNotBlank((String)this.logName) ? this.originalLogger.isInfoEnabled() : this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return StringUtils.isNotBlank((String)this.logName) ? this.originalLogger.isWarnEnabled() : this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return StringUtils.isNotBlank((String)this.logName) ? this.originalLogger.isErrorEnabled() : this.logger.isErrorEnabled();
    }

    public void trace(String arg0) {
        this.originalLogger.trace(arg0);
        this.printLogger.log(arg0, "trace", null);
    }

    public void trace(String arg0, Object arg1) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1).getMessage();
        this.originalLogger.trace(message);
        this.printLogger.log(message, "trace", null);
    }

    public void trace(String arg0, Object arg1, Object arg2) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1, (Object)arg2).getMessage();
        this.originalLogger.trace(message);
        this.printLogger.log(message, "trace", null);
    }

    public void trace(String arg0, Object ... arg1) {
        String message = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
        this.originalLogger.trace(message);
        this.printLogger.log(message, "trace", null);
    }

    public void trace(String arg0, Throwable arg1) {
        this.originalLogger.trace(arg0, arg1);
        this.printLogger.log(arg0, "trace", arg1);
    }

    public void debug(String arg0) {
        this.originalLogger.debug(arg0);
        this.printLogger.log(arg0, "debug", null);
    }

    public void debug(String arg0, Object arg1) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1).getMessage();
        this.originalLogger.debug(message);
        this.printLogger.log(message, "debug", null);
    }

    public void debug(String arg0, Object arg1, Object arg2) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1, (Object)arg2).getMessage();
        this.originalLogger.debug(message);
        this.printLogger.log(message, "debug", null);
    }

    public void debug(String arg0, Object ... arg1) {
        String message = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
        this.originalLogger.debug(message);
        this.printLogger.log(message, "debug", null);
    }

    public void debug(String arg0, Throwable arg1) {
        this.originalLogger.debug(arg0, arg1);
        this.printLogger.log(arg0, "debug", arg1);
    }

    public void info(String arg0) {
        this.originalLogger.info(arg0);
        this.printLogger.log(arg0, "info", null);
    }

    public void info(String arg0, Object arg1) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1).getMessage();
        this.originalLogger.info(message);
        this.printLogger.log(message, "info", null);
    }

    public void info(String arg0, Object arg1, Object arg2) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1, (Object)arg2).getMessage();
        this.originalLogger.info(message);
        this.printLogger.log(message, "info", null);
    }

    public void info(String arg0, Object ... arg1) {
        String message = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
        this.originalLogger.info(message);
        this.printLogger.log(message, "info", null);
    }

    public void info(String arg0, Throwable arg1) {
        this.originalLogger.info(arg0, arg1);
        this.printLogger.log(arg0, "info", arg1);
    }

    public void warn(String arg0) {
        this.originalLogger.warn(arg0);
        this.printLogger.log(arg0, "warn", null);
    }

    public void warn(String arg0, Object arg1) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1).getMessage();
        this.originalLogger.warn(message);
        this.printLogger.log(message, "warn", null);
    }

    public void warn(String arg0, Object arg1, Object arg2) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1, (Object)arg2).getMessage();
        this.originalLogger.warn(message);
        this.printLogger.log(message, "warn", null);
    }

    public void warn(String arg0, Object ... arg1) {
        String message = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
        this.originalLogger.warn(message);
        this.printLogger.log(message, "warn", null);
    }

    public void warn(String arg0, Throwable arg1) {
        this.originalLogger.warn(arg0, arg1);
        this.printLogger.log(arg0, "warn", arg1);
    }

    public void error(String arg0) {
        this.originalLogger.error(arg0);
        this.printLogger.log(arg0, "error", null);
    }

    public void error(String arg0, Object arg1) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1).getMessage();
        this.originalLogger.error(message);
        this.printLogger.log(message, "error", null);
    }

    public void error(String arg0, Object arg1, Object arg2) {
        String message = MessageFormatter.format((String)arg0, (Object)arg1, (Object)arg2).getMessage();
        this.originalLogger.error(message);
        this.printLogger.log(message, "error", null);
    }

    public void error(String arg0, Object ... arg1) {
        String message = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
        this.originalLogger.error(message);
        this.printLogger.log(message, "error", null);
    }

    public void error(String arg0, Throwable arg1) {
        this.originalLogger.error(arg0, arg1);
        this.printLogger.log(arg0, "error", arg1);
    }

    public void debug(Marker arg0, String arg1) {
    }

    public void debug(Marker arg0, String arg1, Object arg2) {
    }

    public void debug(Marker arg0, String arg1, Object ... arg2) {
    }

    public void debug(Marker arg0, String arg1, Throwable arg2) {
    }

    public void debug(Marker arg0, String arg1, Object arg2, Object arg3) {
    }

    public void error(Marker arg0, String arg1) {
    }

    public void error(Marker arg0, String arg1, Object arg2) {
    }

    public void error(Marker arg0, String arg1, Object ... arg2) {
    }

    public void error(Marker arg0, String arg1, Throwable arg2) {
    }

    public void error(Marker arg0, String arg1, Object arg2, Object arg3) {
    }

    public void info(Marker arg0, String arg1) {
    }

    public void info(Marker arg0, String arg1, Object arg2) {
    }

    public void info(Marker arg0, String arg1, Object ... arg2) {
    }

    public void info(Marker arg0, String arg1, Throwable arg2) {
    }

    public void info(Marker arg0, String arg1, Object arg2, Object arg3) {
    }

    public boolean isDebugEnabled(Marker arg0) {
        return false;
    }

    public boolean isErrorEnabled(Marker arg0) {
        return false;
    }

    public boolean isInfoEnabled(Marker arg0) {
        return false;
    }

    public boolean isTraceEnabled(Marker arg0) {
        return false;
    }

    public boolean isWarnEnabled(Marker arg0) {
        return false;
    }

    public void trace(Marker arg0, String arg1) {
    }

    public void trace(Marker arg0, String arg1, Object arg2) {
    }

    public void trace(Marker arg0, String arg1, Object ... arg2) {
    }

    public void trace(Marker arg0, String arg1, Throwable arg2) {
    }

    public void trace(Marker arg0, String arg1, Object arg2, Object arg3) {
    }

    public void warn(Marker arg0, String arg1) {
    }

    public void warn(Marker arg0, String arg1, Object arg2) {
    }

    public void warn(Marker arg0, String arg1, Object ... arg2) {
    }

    public void warn(Marker arg0, String arg1, Throwable arg2) {
    }

    public void warn(Marker arg0, String arg1, Object arg2, Object arg3) {
    }
}

