/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.logger;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import cn.com.duiba.boot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnClass(value={LoggerContext.class})
@ConditionalOnResource(resources={"/logback/loginsight-logback.xml"})
public class LoggerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LoggerAutoConfiguration.class);

    @Bean
    public ApplicationListener loggerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    try {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)loggerContext);
                        configurator.doConfigure(new ClassPathResource("/logback/loginsight-logback.xml").getInputStream());
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.flag = false;
                }
            }
        };
    }

    @Configuration
    @ConditionalOnResource(resources={"/logback/loginsight-logback.xml"})
    @ConditionalOnClass(value={BasicDataSource.class, LoggerContext.class})
    public static class dataSourceMonitorConfigurer {
        @Bean
        public ApplicationListener dataSourceMonitor() {
            return new ApplicationListener<ContextRefreshedEvent>(){
                private boolean initted = false;
                private Map<String, BasicDataSource> dataSourceMap;
                private Map<String, PerfTestRoutingDataSource> routingdataSourceMap;
                private Thread dataSourceMonitorThread;

                public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                    if (!this.initted) {
                        this.initted = true;
                        this.dataSourceMap = applicationStartedEvent.getApplicationContext().getBeansOfType(BasicDataSource.class);
                        this.routingdataSourceMap = applicationStartedEvent.getApplicationContext().getBeansOfType(PerfTestRoutingDataSource.class);
                        if (this.dataSourceMap.isEmpty() && this.routingdataSourceMap.isEmpty()) {
                            return;
                        }
                        this.dataSourceMonitorThread = new Thread(){

                            @Override
                            public void run() {
                                do {
                                    for (Map.Entry entry : dataSourceMap.entrySet()) {
                                        this.scanDataSource((String)entry.getKey(), (BasicDataSource)entry.getValue());
                                    }
                                    for (Map.Entry entry : routingdataSourceMap.entrySet()) {
                                        this.scanDataSource((String)entry.getKey() + "_original", ((PerfTestRoutingDataSource)((Object)entry.getValue())).getOriginalDataSource());
                                        this.scanDataSource((String)entry.getKey() + "_shade", ((PerfTestRoutingDataSource)((Object)entry.getValue())).getShadeDataSource());
                                    }
                                    try {
                                        Thread.sleep(10000L);
                                    }
                                    catch (InterruptedException e) {
                                        break;
                                    }
                                } while (!Thread.currentThread().isInterrupted());
                            }
                        };
                        this.dataSourceMonitorThread.start();
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                dataSourceMonitorThread.interrupt();
                            }
                        });
                    }
                }

                private void scanDataSource(String key, BasicDataSource ds) {
                    if (ds != null && !ds.isClosed()) {
                        int numIdleConnections = ds.getNumIdle();
                        int numBusyConnections = ds.getNumActive();
                        int numConnections = numBusyConnections + numIdleConnections;
                        int max = ds.getMaxTotal();
                        if (numBusyConnections >= 3 && numConnections >= max - 3 && numBusyConnections >= numConnections - 3) {
                            logger.error("datasource [" + key + "]'s connectionPool is too full,max:" + max + ",busy:" + numBusyConnections + ",idle:" + numIdleConnections);
                        }
                    }
                }
            };
        }
    }
}

