/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.dpm;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import cn.com.duiba.boot.ext.autoconfigure.dpm.DpmFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnResource(resources={"/logback/dpm-logback.xml"})
public class DpmAutoConfiguration {
    private static Logger LOG = LoggerFactory.getLogger(DpmAutoConfiguration.class);

    @Bean
    public ApplicationListener loggerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    try {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)loggerContext);
                        configurator.doConfigure(new ClassPathResource("/logback/dpm-logback.xml").getInputStream());
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    this.flag = false;
                }
            }
        };
    }

    @Configuration
    @ConditionalOnWebApplication
    public static class DpmHttpFilterConfiguration {
        @Bean
        public FilterRegistrationBean dpmHttpFilterConfigurer() {
            DpmFilter filter = new DpmFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
            registrationBean.setOrder(1);
            return registrationBean;
        }
    }
}

