/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.dpm;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class DpmFilter
implements Filter {
    private Logger LOG = LoggerFactory.getLogger(DpmFilter.class);
    private Logger DPM_LOG = LoggerFactory.getLogger((String)"dpm_log");
    private static final int DpmTypeClick = 2;
    private static final int DpmTypExposure = 1;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            String dpm = req.getParameter("dpm");
            if (dpm != null && !"".equals(dpm.trim())) {
                DpmLog log = new DpmLog();
                log.setDpm(dpm);
                String dpmType = req.getParameter("dpmType");
                if (dpmType == null) {
                    log.setDpmType(2);
                } else {
                    log.setDpmType(Integer.valueOf(dpmType));
                }
                Cookie[] cookies = req.getCookies();
                HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
                for (Cookie c : cookies) {
                    cookieMap.put(c.getName(), c);
                }
                Cookie _ac = (Cookie)cookieMap.get("_ac");
                if (_ac != null) {
                    String json = new String(new BASE64Decoder().decodeBuffer(_ac.getValue()), "utf-8");
                    JSONObject object = JSONObject.parseObject((String)json);
                    log.setAppId(object.getLong("aid"));
                    log.setConsumerId(object.getLong("cid"));
                } else {
                    String consumerId;
                    String appId = req.getParameter("appId");
                    if (appId != null) {
                        log.setAppId(Long.valueOf(appId));
                    }
                    if ((consumerId = req.getParameter("consumerId")) != null) {
                        log.setConsumerId(Long.valueOf(consumerId));
                    }
                }
                log.setRefererDpm(req.getParameter("referer_dpm"));
                String url = "http://" + req.getServerName() + req.getContextPath() + req.getServletPath() + "?" + req.getQueryString();
                log.setUrl(url);
                log.setRefererUrl(req.getHeader("referer"));
                String ua = req.getHeader("user-agent");
                if (ua != null && ua.length() > 500) {
                    ua = ua.substring(0, 499);
                }
                log.setUa(ua);
                log.setIp(DpmFilter.getIpAddr(req));
                if (log.isValid()) {
                    this.DPM_LOG.info(log.toJson());
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("DpmFilter process error,message= " + e.getMessage());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public static void main(String[] args) throws Exception {
        String s = "eyJhaWQiOjEsImNpZCI6MTUzOTM2MX0=";
        String json = new String(new BASE64Decoder().decodeBuffer(s), "utf-8");
        System.out.println(json);
    }

    public void destroy() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[size - 1].trim();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static class DpmLog {
        private Long appId;
        private Long consumerId;
        private Integer dpmType;
        private String dpm;
        private String refererDpm;
        private String url;
        private String refererUrl;
        private String ua;
        private Date time = new Date();
        private String ip;

        private DpmLog() {
        }

        public String toJson() {
            JSONObject json = new JSONObject();
            json.put("appId", (Object)this.appId);
            json.put("consumerId", (Object)this.consumerId);
            json.put("dpmType", (Object)this.dpmType);
            json.put("dpm", (Object)this.dpm);
            json.put("time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.time));
            if (this.refererDpm != null) {
                json.put("refererDpm", (Object)this.refererDpm);
            }
            if (this.url != null) {
                json.put("url", (Object)this.url);
            }
            if (this.refererUrl != null) {
                json.put("refererUrl", (Object)this.refererUrl);
            }
            if (this.ua != null) {
                json.put("ua", (Object)this.ua);
            }
            if (this.ip != null) {
                json.put("ip", (Object)this.ip);
            }
            return json.toJSONString();
        }

        public boolean isValid() {
            if (this.appId == null || this.appId <= 0L) {
                return false;
            }
            if (this.consumerId == null || this.consumerId <= 0L) {
                return false;
            }
            if (this.dpm == null) {
                return false;
            }
            return this.dpmType != null;
        }

        public String getDpm() {
            return this.dpm;
        }

        public void setDpm(String dpm) {
            this.dpm = dpm;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUa() {
            return this.ua;
        }

        public void setUa(String ua) {
            this.ua = ua;
        }

        public Date getTime() {
            return this.time;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public Long getConsumerId() {
            return this.consumerId;
        }

        public void setConsumerId(Long consumerId) {
            this.consumerId = consumerId;
        }

        public Integer getDpmType() {
            return this.dpmType;
        }

        public void setDpmType(Integer dpmType) {
            this.dpmType = dpmType;
        }

        public String getRefererDpm() {
            return this.refererDpm;
        }

        public void setRefererDpm(String refererDpm) {
            this.refererDpm = refererDpm;
        }

        public String getRefererUrl() {
            return this.refererUrl;
        }

        public void setRefererUrl(String refererUrl) {
            this.refererUrl = refererUrl;
        }
    }
}

