package cn.com.duiba.boot.ext.autoconfigure.mybatis;

import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.servlet.Servlet;
import java.lang.reflect.Method;

/**
 * mybatis自动配置，目前用于修复mybatis在spring下的一个问题：https://github.com/mybatis/mybatis-3/issues/325
 * 这个问题大概表现是：springboot打成jar包后，运行时，mybatis会扫描typeAliasesPackage配置下的类，由于这个类在springboot jar内部的嵌入jar中，导致找不到该类。
 *
 * Created by wenqi.huang on 2016/11/22.
 */
@Configuration
@ConditionalOnClass({SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, VFS.class})
public class MybatisAutoConfiguration {

    @Configuration
    public static class MyBatisPostProcessorConfiguration{

        /**
         * 声明后置处理器，spring全部bean初始化完成前调用，给所有 SqlSessionFactoryBean 注入自定义的VFS，修复bug
         * @return
         */
        @Bean
        public BeanPostProcessor myBatisPostProcessorConfigurer(){
            boolean hasVfsMethod = false;
            try {
                Method m = SqlSessionFactoryBean.class.getMethod("getVfs");
                hasVfsMethod = true;
            } catch (NoSuchMethodException e) {
                // Ignore
            }

            final boolean hasVfsMethodFinal = hasVfsMethod;

            return new BeanPostProcessor() {

                @Override
                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    if(hasVfsMethodFinal) {
                        if (bean instanceof SqlSessionFactoryBean) {
                            SqlSessionFactoryBean f = ((SqlSessionFactoryBean) bean);
                            if (f.getVfs() == null) {
                                f.setVfs(SpringBootVFS.class);
                            }
                        }
                    }

                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }
            };

        }
    }
}
