package cn.com.duiba.boot.ext.autoconfigure.dpm;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;

import javax.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 *
 * 监控Url请求,自动解析其中的dpm参数,进行日志输出,统一格式,用于收集日志,方便实时采集到大数据平台
 * Created by xuhengfei on 16/12/20.
 */
@Configuration
@ConditionalOnResource(resources = "/logback/dpm-logback.xml")
public class DpmAutoConfiguration {

    private static Logger LOG=LoggerFactory.getLogger(DpmAutoConfiguration.class);

    @Configuration
    @ConditionalOnWebApplication
    public static class DpmHttpFilterConfiguration{
        @Bean
        public FilterRegistrationBean dpmHttpFilterConfigurer(){
            DpmFilter filter=new DpmFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter(filter);
            List<String> urlPatterns=new ArrayList<String>();
            urlPatterns.add("/*");//拦截路径，可以添加多个
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
            registrationBean.setOrder(1);
            return registrationBean;
        }
    }

    /**
     * 附加logback配置文件
     * @return
     */
    @Bean
    public ApplicationListener loggerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            private boolean flag = true;

            @Override
            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if(flag){
                    try {
                        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext(loggerContext);
                        //logback 添加新的配置文件
                        configurator.doConfigure(new ClassPathResource("/logback/dpm-logback.xml").getInputStream());
                    } catch (Exception e) {
                        LOG.error(e.getMessage(), e);
                    }
                    flag = false;
                }
            }
        };
    }
}
