package cn.com.duiba.boot.ext.autoconfigure.logger.logback;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;

/**
 * 这个Converter用于输出的msg,如果多行，压缩成一行，以防json解析出错
 * Created by wenqi.huang on 2016/12/23.
 */
public class MsgInOneLineConverter extends ClassicConverter {
    @Override
    public String convert(ILoggingEvent event) {
        String message = event.getFormattedMessage();
        if(message != null) {
            message = message.replaceAll(CoreConstants.LINE_SEPARATOR + CoreConstants.TAB, ExceptionInOneLineConverter.SEPARATOR);
            message = message.replaceAll(CoreConstants.LINE_SEPARATOR, ExceptionInOneLineConverter.SEPARATOR);
        }
        return message;
    }
}
