package cn.com.duiba.boot.ext.autoconfigure.memcached;

import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.XMemcacheClient;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.velocity.VelocityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by wenqi.huang on 2016/11/4.
 */
@Configuration
@EnableConfigurationProperties(MemcachedProperties.class)
public class MemcachedClientAutoConfiguration {

    protected static abstract class MemcachedClientConfiguration{

        @Autowired
        protected MemcachedProperties memcachedProperties;

        public abstract CacheClient buildCacheClient();

    }

    @ConditionalOnClass({MemcachedClient.class, XMemcacheClient.class})
    @ConditionalOnProperty(name="duiba.memcached.servers", matchIfMissing = false)
    @ConditionalOnMissingBean(name={"cacheClient"})
    protected static class XMemcachedClientConfiguration extends MemcachedClientConfiguration{

        @Bean(name="cacheClient")
        @Override
        public CacheClient buildCacheClient(){
            XMemcacheClient cacheClient = new XMemcacheClient();
            cacheClient.setServers(memcachedProperties.getServers());
            cacheClient.setUsername(memcachedProperties.getUsername());
            cacheClient.setPassword(memcachedProperties.getPassword());
            cacheClient.setAuthInfos(memcachedProperties.getAuthInfos());
            cacheClient.setProtocol(memcachedProperties.getProtocol());
            cacheClient.setEnableHeartBeat(memcachedProperties.getEnableHeartBeat());
            cacheClient.setConnectionPoolSize(memcachedProperties.getConnectionPoolSize());
            cacheClient.setOperationTimeout(memcachedProperties.getOperationTimeout());

            return cacheClient;
        }
    }

}
