package cn.com.duiba.boot.ext.autoconfigure.selfaware;

import cn.com.duiba.wolf.spring.selfaware.SelfAware;
import cn.com.duiba.wolf.spring.selfaware.SelfAwareBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by wenqi.huang on 2017/2/5.
 */
@Configuration
@ConditionalOnClass({SelfAwareBeanPostProcessor.class, SelfAware.class})
@ConditionalOnMissingBean(SelfAwareBeanPostProcessor.class)
public class SelfAwareAutoConfiguration {

    @Bean
    public BeanPostProcessor selfAwareBeanPostProcessor(){
        return new SelfAwareBeanPostProcessor();
    }
}
