package cn.com.duiba.boot.ext.autoconfigure.xss;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * Created by wenqi.huang on 16/8/22.
 */
public class XssHttpServletRequestWrapper extends HttpServletRequestWrapper {
    /**
     * Creates a new instance of XssHttpServletRequestWrapper.
     *
     * @param servletRequest
     */
    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    @Override
    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; i++) {
            encodedValues[i] = cleanXSS(values[i]);
        }
        return encodedValues;
    }
    
    @Override
    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return cleanXSS(value);
    }

//    @Override
//    public String getHeader(String name) {
//        String value = super.getHeader(name);
//        return cleanXSS(value);
//    }

    private String cleanXSS(String value) {
        if (value == null) {
            return null;
        }

        value = StringUtils.replace(value,"\\t"," ");//js里不能解析含有制表符\t的json字符串，所以做这个处理
        value = StringUtils.replace(value,"\t"," ");
        return StringEscapeUtils.escapeHtml3(value);
        //You'll need to remove the spaces from the html entities below
//        value = value.replaceAll("<", "& lt;").replaceAll(">", "& gt;");
//        value = value.replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;");
//        value = value.replaceAll("'", "& #39;");
//        value = value.replaceAll("eval\\((.*)\\)", "");
//        value = value.replaceAll("[\\\"\\\'][\\s]*javascript:(.*)[\\\"\\\']", "\"\"");
//        value = value.replaceAll("script", "");
//        return value;
    }

}
