package cn.com.duiba.boot.ext.autoconfigure.logger.logback;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;

/**
 * 这个Converter用于输出异常的message
 * Created by wenqi.huang on 2016/12/23.
 */
public class ExceptionMessageConverter extends ClassicConverter {
    @Override
    public String convert(ILoggingEvent event) {
        if(event.getThrowableProxy() == null){
            return "";
        }
        String errorMessage = event.getThrowableProxy().getMessage();
        if(errorMessage!=null) {
            errorMessage = errorMessage.replaceAll(CoreConstants.LINE_SEPARATOR + CoreConstants.TAB, ExceptionInOneLineConverter.SEPARATOR);
            errorMessage = errorMessage.replaceAll(CoreConstants.LINE_SEPARATOR, ExceptionInOneLineConverter.SEPARATOR);
        }
        return errorMessage;
    }
}
