package cn.com.duiba.boot.ext.autoconfigure.accesslog;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xuhengfei on 16/12/27.
 */
public class AccessLogFilter implements Filter{

    public static ThreadLocal<Long> AppId=new ThreadLocal<>();
    public static ThreadLocal<Long> ConsumerId=new ThreadLocal<>();
    public static ThreadLocal<Map<String,String>> LogCookie=new ThreadLocal<>();


    private static Logger AccessLog= LoggerFactory.getLogger("duiba_access_log");

    private static Logger log=LoggerFactory.getLogger(AccessLogFilter.class);

    private static final String DUIBA_PERF="_duibaPerf";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {

        try {
            HttpServletRequest req = (HttpServletRequest) servletRequest;
            //判断是否性能压测url
            boolean isPerfUrl=false;

            String _duibaPerf=req.getParameter(DUIBA_PERF);
            if(_duibaPerf!=null && "1".equals(_duibaPerf)){
                isPerfUrl=true;
            }

            if(!isPerfUrl){
                Cookie[] cookies = req.getCookies();
                if(cookies!=null){
                    for(Cookie c:cookies){
                        if(DUIBA_PERF.equals(c.getName()) && "1".equals(c.getValue())){
                            isPerfUrl=true;
                            break;
                        }
                    }
                }

            }

            if(!isPerfUrl){
                processAccessLog(req,(HttpServletResponse)servletResponse);
            }


        }catch (Exception e){
            log.error("AccessLogFilter process error, message="+e.getMessage());
        }

        try {

            filterChain.doFilter(servletRequest, servletResponse);

        }finally {
            AppId.remove();
            ConsumerId.remove();
            LogCookie.remove();
        }
    }


    private void processAccessLog(HttpServletRequest req, HttpServletResponse resp) throws Exception{
        //只记录get post请求
        if(!"get".equalsIgnoreCase(req.getMethod()) && !"post".equalsIgnoreCase(req.getMethod())){
            return;
        }

        Map<String, Object> map = new HashMap<>();
        map.put("url_host", req.getHeader("host"));
        map.put("url_path", req.getRequestURI());
        map.put("url_query", req.getQueryString());

        map.put("http_method",req.getMethod());

        //如果url中有callback参数,认为此url是一个JSONP请求,标记为POST类型,不作为PV统计
        String callback=req.getParameter("callback");
        if(callback!=null && !"".equals(callback.trim())){
            map.put("http_method","POST");
        }



        Cookie[] cookies = req.getCookies();
        Map<String, Cookie> cookieMap = new HashMap<>();
        if(cookies!=null){
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c);
            }
        }


        //优先从线程变量中取数据
        Long consumerId=ConsumerId.get();
        if(consumerId!=null){
            map.put("consumer_id",consumerId);
        }

        Long appId=AppId.get();
        if(appId!=null){
            map.put("app_id",appId);
        }

        Cookie _ac = cookieMap.get("_ac");
        if (_ac != null){
            if(consumerId==null || appId==null){//如果还没有取到,尝试从cookie取数据
                try {
                    String json = new String(new BASE64Decoder().decodeBuffer(_ac.getValue()), "utf-8");
                    if(json!=null){
                        JSONObject object = JSONObject.parseObject(json);
                        if(appId==null){
                            map.put("app_id",object.getLong("aid"));
                        }
                        if(consumerId==null){
                            map.put("consumer_id",object.getLong("cid"));
                        }
                    }
                }catch(Exception e){
                    log.warn("_ac decode fail , _ac= "+_ac.getValue());
                }
            }

        }


        Map<String,String> collCookie=new HashMap<String,String>();

        for(String key:cookieMap.keySet()){
            if(key.startsWith("_coll_")){
                collCookie.put(key,cookieMap.get(key).getValue());
            }
        }


        Map<String,String[]> params=req.getParameterMap();
        for(String key:params.keySet()){
            if(key.startsWith("tck_")){
                String[] v=key.split("_");
                if(v.length==3){
                    String verify=MD5.md5(v[1]);
                    if(verify.endsWith(v[2])){
                        String name=v[1];
                        String value=req.getParameter(key);
                        //验证通过
                        String cookiekey="_coll_"+name;
                        collCookie.put(cookiekey,value);
                        //写入cookie
                        Cookie cookie = new Cookie(cookiekey, value);
                        cookie.setPath("/");
                        resp.addCookie(cookie);

                    }
                }
            }
        }

        //特殊处理
        String slotId=req.getParameter("adslotId");
        if(slotId!=null){
            collCookie.put("_coll_slot",slotId);
        }
        String deviceId=req.getParameter("deviceId");
        if(deviceId!=null){
            collCookie.put("_coll_device",deviceId);
        }

        //支持线程变量中取cookie进行日志打印,便于不同系统的一些定制需求,此为cookie的最高优先级获取方法
        Map<String,String> logCookie=LogCookie.get();
        if(logCookie!=null){
            for(String key:logCookie.keySet()){
                collCookie.put(key,logCookie.get(key));
            }
        }

        if(!collCookie.isEmpty()){
            map.put("cookie",collCookie);
        }


        String ua = req.getHeader("user-agent");
        if (ua != null && ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (ua != null) {
            map.put("user_agent", ua);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = req.getHeader("referer");
        if (referer != null) {
            map.put("referer", referer);
        }
        String ip = getIpAddr(req);
        if (ip != null) {
            map.put("ip", ip);
        }


        AccessLog.info(JSON.toJSONString(map));
    }

    @Override
    public void destroy() {

    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if(ip!=null && ip.trim().length()>0){
            String[] ips=ip.trim().split(",");
            int size=ips.length;
            if(size>0){
                ip=ips[size-1].trim();
            }
        }
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)){
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if(ip!=null && ip.startsWith("0:0:0:0")){
            ip="127.0.0.1";
        }
        return ip;
    }

}
