package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.catmonitor.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;

/**
 * 加入aop，监控spring-data-redis执行耗时
 */
@Aspect
public class CatSpringDataRedisPlugin {

	private static final Logger logger = LoggerFactory.getLogger(CatSpringDataRedisPlugin.class);

	private volatile Class<?> lastJedisConnectionProxyClass;

	@Around("execution(* org.springframework.data.redis.connection.jedis.JedisConnectionFactory.getConnection(..))")
	public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();
		if(CatInstance.isEnable()){
			if("getConnection".equals(methodName)){
				JedisConnection connection = (JedisConnection)joinPoint.proceed();

				ProxyFactory factory = new ProxyFactory();
				factory.setTarget(connection);
				//factory.setTargetClass(JedisConnection.class);
				factory.addAdvice(new JedisMethodInterceptor());
				JedisConnection newConnection = (JedisConnection) factory.getProxy();//getClass().getClassLoader()

				if(lastJedisConnectionProxyClass != null && lastJedisConnectionProxyClass != newConnection.getClass()){
					logger.error("JedisConnectionProxyClass is not same，this is spring's bug,please upgrade spring-boot's version to 1.3.8.RELEASE or higher! {},{},{},{}",new Object[]{getClass().getClassLoader(), newConnection.getClass().getClassLoader(),lastJedisConnectionProxyClass, newConnection.getClass()});//如果抱这个错，则有perm区内存溢出的风险，需要关注
				}
				lastJedisConnectionProxyClass = newConnection.getClass();

				return newConnection;
			}
		}

		return joinPoint.proceed();
	}

	/**
	 * {@link MethodInterceptor}
	 */
	private static class JedisMethodInterceptor implements MethodInterceptor {

		JedisMethodInterceptor() {
		}

		@Override
		public Object invoke(MethodInvocation invocation) throws Throwable {
			String methodName = invocation.getMethod().getName();
			//忽略Object基类中的方法
			if(methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")){
				return invocation.proceed();
			}

			if(methodName.equals("isPipelined") || methodName.equals("openPipeline") || methodName.equals("isQueueing")
					|| methodName.equals("isClosed")
					|| methodName.equals("getNativeConnection")
					|| methodName.equals("close")
					|| methodName.equals("closePipeline")){
				return invocation.proceed();
			}

			if(CatInstance.isEnable()){
				Transaction transaction = null;
				if("get".equals(methodName)){
					transaction = Cat.newTransaction("Cache.dataRedis", methodName + ":" + methodName);
				}else{
					transaction = Cat.newTransaction("Cache.dataRedis", methodName);
				}
				try {
					Object value = invocation.proceed();
					if("get".equals(methodName) && value == null){
						Cat.logEvent("Cache.dataRedis", methodName + ":missed");
					}
					transaction.setStatus(Message.SUCCESS);
					return value;
				} catch (Throwable e) {
					Cat.logError(e);
					transaction.setStatus(e);
					throw e;
				}finally{
					transaction.complete();
				}
			}

			return invocation.proceed();
		}

	}

}
