package cn.com.duiba.boot.ext.autoconfigure.velocity;

import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.velocity.VelocityAutoConfiguration;
import org.springframework.boot.web.servlet.view.velocity.EmbeddedVelocityViewResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.ui.velocity.VelocityEngineFactory;
import org.springframework.web.servlet.view.velocity.VelocityView;

import javax.annotation.PostConstruct;
import javax.servlet.Servlet;

/**
 * 修复spring-boot使用velocity永久区内存溢出的bug
 * Created by wenqi.huang on 2017/2/4.
 */
@Configuration
@ConditionalOnClass({ VelocityEngine.class, VelocityEngineFactory.class,Servlet.class })
@ConditionalOnWebApplication
@AutoConfigureAfter(VelocityAutoConfiguration.class)
public class VelocityFixAutoConfiguration {

    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void changeVelocityViewClass(){
        Object bean = applicationContext.getBean("velocityViewResolver");
        if(bean == null || !(bean instanceof EmbeddedVelocityViewResolver)){
            return;
        }

        EmbeddedVelocityViewResolver vs = (EmbeddedVelocityViewResolver)bean;
        vs.setViewClass(FixedVelocityToolboxView.class);
    }
}
