package cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import org.springframework.context.SmartLifecycle;

import java.util.concurrent.*;

/**
 * {@link TransmittableThreadLocal} Wrapper of {@link ScheduledExecutorService},
 * transmit the {@link TransmittableThreadLocal} from the task submit time of {@link Runnable} or {@link Callable}
 * to the execution time of {@link Runnable} or {@link Callable}.
 *
 * @author Jerry Lee (oldratlee at gmail dot com)
 * @since 0.9.0
 */
public class ScheduledThreadPoolExecutorWrapper extends ThreadPoolExecutorWrapper implements ScheduledExecutorService, SmartLifecycle {
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    /**
     *
     * @param scheduledThreadPoolExecutor
     * @param shutdownTimeout 优雅停机时间，超时则强制关闭
     */
    public ScheduledThreadPoolExecutorWrapper(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long shutdownTimeout) {
        super(scheduledThreadPoolExecutor, shutdownTimeout);
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return scheduledThreadPoolExecutor.schedule(TtlRunnable.get(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return scheduledThreadPoolExecutor.schedule(TtlCallable.get(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return scheduledThreadPoolExecutor.scheduleAtFixedRate(TtlRunnable.get(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return scheduledThreadPoolExecutor.scheduleWithFixedDelay(TtlRunnable.get(command), initialDelay, delay, unit);
    }


}
