package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Created by wenqi.huang on 2017/4/11.
 */
@RestController
public class BootMonitorController {

    private volatile boolean inService = true;

    /**
     * 检查服务器状态，OK表示正常，INVALID表示服务不可用
     * @param response
     * @return
     */
    @RequestMapping("/monitor/check")
    public String check(HttpServletResponse response){
        if(!inService){
            response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
        }
        return inService ? "OK" : "INVALID";
    }

    /**
     * 让check接口返回INVALID
     * @param request
     * @return
     */
    @RequestMapping("/monitor/stop")
    public String stop(HttpServletRequest request){
        if(!isLocalRequest(request)){
            return "NO PERMISSION";
        }
        inService = false;
        return "OK";
    }

    /**
     * 让check接口返回OK
     * @param request
     * @return
     */
    @RequestMapping("/monitor/start")
    public String start(HttpServletRequest request){
        if(!isLocalRequest(request)){
            return "NO PERMISSION";
        }
        inService = true;
        return "OK";
    }

    /**
     * 访问的来源ip必须是127.0.0.1， 并且访问的url也必须是127.0.0.1
     * @param request
     * @return
     */
    private boolean isLocalRequest(HttpServletRequest request){
        boolean isFromLocalIp = RequestTool.isLocalRequest(request);
        if(!isFromLocalIp){
            return false;
        }
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if(url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        } catch (MalformedURLException e) {
            // Ignore
        }

        return isUrlFromLocal;
    }
}
