/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.accesslog;

import cn.com.duiba.boot.ext.autoconfigure.accesslog.MD5;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class AccessLogFilter
implements Filter {
    public static ThreadLocal<Long> AppId = new ThreadLocal();
    public static ThreadLocal<Long> ConsumerId = new ThreadLocal();
    public static ThreadLocal<Map<String, String>> LogCookie = new ThreadLocal();
    public static ThreadLocal<Map<String, String>> EX = new ThreadLocal();
    public static final String ModeBlack = "black";
    public static final String ModeWhite = "white";
    private String mode = "black";
    private List<String> inhosts = new ArrayList<String>();
    private static Logger AccessLog = LoggerFactory.getLogger((String)"duiba_access_log");
    private static Logger log = LoggerFactory.getLogger(AccessLogFilter.class);
    private static final String DUIBA_PERF = "_duibaPerf";
    private Map<String, String> cookieHosts = new ConcurrentHashMap<String, String>();
    private static String LocalIP = null;

    public void loadConfig(Properties properties) {
        List<String> hosts;
        this.mode = properties.getProperty("accesslog.mode");
        String hoststring = properties.getProperty("accesslog.hosts");
        if (hoststring != null && (hosts = Arrays.asList(hoststring.trim().split(","))) != null && !hosts.isEmpty()) {
            this.inhosts = hosts;
        }
    }

    private boolean needLog(HttpServletRequest req) {
        String host = req.getHeader("host");
        if (ModeBlack.equals(this.mode)) {
            return !this.inhosts.contains(host);
        }
        if (ModeWhite.equals(this.mode)) {
            return this.inhosts.contains(host);
        }
        return true;
    }

    public static void putLogCookie(String key, String value) {
        Map<String, String> map = LogCookie.get();
        if (map == null) {
            map = new HashMap<String, String>();
            LogCookie.set(map);
        }
        map.put(key, value);
    }

    public static void putExPair(String key, String value) {
        Map<String, String> ex = EX.get();
        if (ex == null) {
            ex = new HashMap<String, String>();
            EX.set(ex);
        }
        ex.put(key, value);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Long startTime = System.currentTimeMillis();
        HashMap<String, String> collCookie = new HashMap<String, String>();
        try {
            try {
                this.addCookieIfNeed((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, collCookie);
            }
            catch (Exception e) {
                log.error("addCookieIfNeed error");
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            try {
                Cookie[] cookies;
                HttpServletRequest req = (HttpServletRequest)servletRequest;
                boolean isPerfUrl = false;
                String _duibaPerf = req.getParameter(DUIBA_PERF);
                if (_duibaPerf != null && "1".equals(_duibaPerf)) {
                    isPerfUrl = true;
                }
                if (!isPerfUrl && (cookies = req.getCookies()) != null) {
                    for (Cookie c : cookies) {
                        if (!DUIBA_PERF.equals(c.getName()) || !"1".equals(c.getValue())) continue;
                        isPerfUrl = true;
                        break;
                    }
                }
                if (!isPerfUrl && this.needLog(req)) {
                    this.processAccessLog(req, (HttpServletResponse)servletResponse, startTime, collCookie);
                }
            }
            catch (Exception e) {
                log.error("AccessLogFilter process error, message=" + e.getMessage());
            }
            AppId.remove();
            ConsumerId.remove();
            LogCookie.remove();
            EX.remove();
        }
    }

    private void addCookieIfNeed(HttpServletRequest req, HttpServletResponse resp, Map<String, String> collCookie) {
        Map params = req.getParameterMap();
        String host = req.getHeader("host");
        String cookieHost = this.getCookieHost(host);
        if (cookieHost != null) {
            for (String key : params.keySet()) {
                String[] v;
                if (key.startsWith("tck_") && (v = key.split("_")).length == 3) {
                    String verify = null;
                    try {
                        verify = MD5.md5(v[1]);
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (verify.endsWith(v[2])) {
                        String name = v[1];
                        String value = req.getParameter(key);
                        String cookiekey = "_coll_" + name;
                        collCookie.put(cookiekey, value);
                        Cookie cookie = new Cookie(cookiekey, value);
                        cookie.setDomain(cookieHost);
                        cookie.setPath("/");
                        try {
                            resp.addCookie(cookie);
                        }
                        catch (Exception e) {
                            log.error("addCookie error,cookieKey=" + cookiekey + ",value=" + value, (Throwable)e);
                        }
                    }
                }
                if (!"rid".equals(key)) continue;
                String value = req.getParameter(key);
                String cookieKey = "_coll_" + key;
                collCookie.put(cookieKey, value);
                Cookie cookie = new Cookie(cookieKey, value);
                cookie.setDomain(cookieHost);
                cookie.setPath("/");
                try {
                    resp.addCookie(cookie);
                }
                catch (Exception e) {
                    log.error("addCookie error,cookieKey=" + cookieKey + ",value=" + value, (Throwable)e);
                }
            }
        }
    }

    private void processAccessLog(HttpServletRequest req, HttpServletResponse resp, long startTime, Map<String, String> collCookie) throws Exception {
        String ip;
        String ua;
        Map<String, String> logCookie;
        String deviceId;
        String slotId;
        Cookie _ac;
        Long appId;
        Long consumerId;
        String callback;
        if (!"get".equalsIgnoreCase(req.getMethod()) && !"post".equalsIgnoreCase(req.getMethod())) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url_host", req.getHeader("host"));
        map.put("url_path", req.getRequestURI());
        map.put("url_query", req.getQueryString());
        map.put("http_method", req.getMethod());
        map.put("rc", resp.getStatus());
        map.put("rt", System.currentTimeMillis() - startTime);
        map.put("mip", AccessLogFilter.getLocalIp());
        if (EX.get() != null) {
            map.put("ex", JSON.toJSONString(EX.get()));
        }
        if ((callback = req.getParameter("callback")) != null && !"".equals(callback.trim())) {
            map.put("http_method", "POST");
        }
        Cookie[] cookies = req.getCookies();
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        if (cookies != null) {
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c);
            }
        }
        if ((consumerId = ConsumerId.get()) != null) {
            map.put("consumer_id", consumerId);
        }
        if ((appId = AppId.get()) != null) {
            map.put("app_id", appId);
        }
        if ((_ac = (Cookie)cookieMap.get("_ac")) != null && (consumerId == null || appId == null)) {
            try {
                String json = new String(new BASE64Decoder().decodeBuffer(_ac.getValue()), "utf-8");
                if (json != null) {
                    JSONObject object = JSONObject.parseObject((String)json);
                    if (appId == null) {
                        map.put("app_id", object.getLong("aid"));
                    }
                    if (consumerId == null) {
                        map.put("consumer_id", object.getLong("cid"));
                    }
                }
            }
            catch (Exception e) {
                log.warn("_ac decode fail , _ac= " + _ac.getValue());
            }
        }
        for (String key : cookieMap.keySet()) {
            if (!key.startsWith("_coll_")) continue;
            collCookie.put(key, ((Cookie)cookieMap.get(key)).getValue());
        }
        Map params = req.getParameterMap();
        String host = req.getHeader("host");
        String cookieHost = this.getCookieHost(host);
        if (cookieHost != null) {
            for (String key : params.keySet()) {
                String verify;
                String[] v;
                if (key.startsWith("tck_") && (v = key.split("_")).length == 3 && (verify = MD5.md5(v[1])).endsWith(v[2])) {
                    String name = v[1];
                    String value = req.getParameter(key);
                    String cookiekey = "_coll_" + name;
                    collCookie.put(cookiekey, value);
                    Cookie cookie = new Cookie(cookiekey, value);
                    cookie.setDomain(cookieHost);
                    cookie.setPath("/");
                    resp.addCookie(cookie);
                }
                if (!"rid".equals(key)) continue;
                String value = req.getParameter(key);
                String cookieKey = "_coll_" + key;
                collCookie.put(cookieKey, value);
                Cookie cookie = new Cookie(cookieKey, value);
                cookie.setDomain(cookieHost);
                cookie.setPath("/");
                resp.addCookie(cookie);
            }
        }
        if ((slotId = req.getParameter("adslotId")) != null) {
            collCookie.put("_coll_slot", slotId);
        }
        if ((deviceId = req.getParameter("deviceId")) != null) {
            collCookie.put("_coll_device", deviceId);
        }
        if ((logCookie = LogCookie.get()) != null) {
            for (String key : logCookie.keySet()) {
                collCookie.put(key, logCookie.get(key));
            }
        }
        if (!collCookie.isEmpty()) {
            map.put("cookie", collCookie);
        }
        if ((ua = req.getHeader("user-agent")) != null && ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (ua != null) {
            map.put("user_agent", ua);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = req.getHeader("referer");
        if (referer != null) {
            map.put("referer", referer);
        }
        if ((ip = AccessLogFilter.getIpAddr(req)) != null) {
            map.put("ip", ip);
        }
        AccessLog.info(JSON.toJSONString(map));
    }

    private String getCookieHost(String host) {
        String cookieHost;
        if (host == null) {
            return null;
        }
        if (host.contains(":")) {
            host = host.substring(0, host.indexOf(":"));
        }
        if ((cookieHost = this.cookieHosts.get(host)) != null) {
            return cookieHost;
        }
        String hostLow = host.toLowerCase();
        if (hostLow.endsWith(".duiba.com.cn")) {
            cookieHost = ".duiba.com.cn";
        } else if (hostLow.endsWith(".dui88.com")) {
            cookieHost = ".dui88.com";
        } else if (hostLow.endsWith(".duibar.com")) {
            cookieHost = ".duibar.com";
        } else if (hostLow.endsWith(".tuia.cn")) {
            cookieHost = ".tuia.cn";
        }
        if (cookieHost != null) {
            this.cookieHosts.put(host, cookieHost);
        }
        return cookieHost;
    }

    public void destroy() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[size - 1].trim();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static String getLocalIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (LocalIP != null) {
            return LocalIP;
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error(" NetworkInterface.getNetworkInterfaces error", (Throwable)e);
            return null;
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                LocalIP = ip.getHostAddress();
                return LocalIP;
            }
        }
        return LocalIP;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(AccessLogFilter.getLocalIp());
    }
}

