/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.security;

import java.io.FileDescriptor;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.sql.SQLPermission;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.LoggingPermission;
import javax.security.auth.AuthPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
public class SecurityManagerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SecurityManagerAutoConfiguration.class);
    static Set<String> forbiddenPermNames = new HashSet<String>(10);

    private static boolean conditionalOnMissingClass(String ... classNames) {
        boolean existsOne = false;
        for (String className : classNames) {
            try {
                Class.forName(className);
                existsOne = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return !existsOne;
    }

    @Bean
    public ApplicationListener _duibaSecurityManagerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    if (System.getSecurityManager() == null) {
                        System.setSecurityManager(new SecurityManager(){

                            @Override
                            public void checkExec(String cmd) {
                                super.checkExec(cmd);
                            }

                            @Override
                            public void checkCreateClassLoader() {
                            }

                            @Override
                            public void checkRead(String file) {
                            }

                            @Override
                            public void checkRead(String file, Object context) {
                            }

                            @Override
                            public void checkWrite(String file) {
                            }

                            @Override
                            public void checkDelete(String file) {
                            }

                            @Override
                            public void checkPackageAccess(String pkg) {
                            }

                            @Override
                            public void checkAccess(Thread t) {
                            }

                            @Override
                            public void checkAccess(ThreadGroup g) {
                            }

                            public void checkMemberAccess(Class<?> clazz, int which) {
                                String className = clazz.getName();
                                if (className.equals("java.lang.ProcessImpl") || className.equals("java.lang.UNIXProcess") || className.equals("java.lang.ProcessBuilder")) {
                                    throw new AccessControlException("not allowed to reflect access class:" + className);
                                }
                            }

                            @Override
                            public void checkPermission(Permission perm) {
                                FilePermission fp;
                                if (perm instanceof AllPermission || perm instanceof PropertyPermission || perm instanceof SerializablePermission || perm instanceof ReflectPermission || perm instanceof NetPermission || perm instanceof SQLPermission || perm instanceof SecurityPermission || perm instanceof LoggingPermission || perm instanceof AuthPermission || perm instanceof SocketPermission) {
                                    return;
                                }
                                if (perm instanceof FilePermission && (fp = (FilePermission)perm).getActions().equals("execute")) {
                                    super.checkPermission(perm);
                                    return;
                                }
                                if (forbiddenPermNames.contains(perm.getName())) {
                                    super.checkPermission(perm);
                                    return;
                                }
                            }

                            @Override
                            public void checkPermission(Permission perm, Object context) {
                            }

                            @Override
                            public void checkExit(int status) {
                            }

                            @Override
                            public void checkLink(String lib) {
                            }

                            @Override
                            public void checkRead(FileDescriptor fd) {
                            }

                            @Override
                            public void checkWrite(FileDescriptor fd) {
                            }

                            @Override
                            public void checkConnect(String host, int port) {
                            }

                            @Override
                            public void checkConnect(String host, int port, Object context) {
                            }

                            @Override
                            public void checkListen(int port) {
                            }

                            @Override
                            public void checkAccept(String host, int port) {
                            }

                            @Override
                            public void checkMulticast(InetAddress maddr) {
                            }

                            @Override
                            public void checkMulticast(InetAddress maddr, byte ttl) {
                            }

                            @Override
                            public void checkPropertiesAccess() {
                            }

                            @Override
                            public void checkPropertyAccess(String key) {
                            }

                            @Override
                            public void checkPackageDefinition(String pkg) {
                            }

                            @Override
                            public void checkSetFactory() {
                            }

                            @Override
                            public void checkSecurityAccess(String target) {
                            }
                        });
                    }
                    this.flag = false;
                }
            }
        };
    }

    static {
        forbiddenPermNames.add("queuePrintJob");
        if (SecurityManagerAutoConfiguration.conditionalOnMissingClass("org.junit.Test", "org.testng.annotations.Test")) {
            forbiddenPermNames.add("setIO");
            forbiddenPermNames.add("setSecurityManager");
        } else {
            logger.warn("\u4fa6\u6d4b\u5230\u5728\u6d4b\u8bd5\u6a21\u5f0f, SecurityManager\u5141\u8bb8\u6743\u9650:[setIO/setSecurityManager],\u5982\u679c\u5728\u76f4\u63a5\u8fd0\u884cApplication.java\u65f6\uff08\u975e\u6d4b\u8bd5\u6a21\u5f0f\uff09\u770b\u5230\u8fd9\u6761\u65e5\u5fd7\uff0c\u8bf7\u786e\u4fdd\u628ajunit/testng/spring-test\u7b49\u6d4b\u8bd5\u6846\u67b6\u8bbe\u7f6e\u4e3atestCompile\u4f9d\u8d56\u6a21\u5f0f\uff08\u5373\u6253\u7684jar\u5305\u4e2d\u4e0d\u8981\u5305\u542bjunit/testng\u7684jar\u5305\uff09");
        }
    }
}

