/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BootMonitorController {
    private volatile boolean inService = true;

    @RequestMapping(value={"/monitor/check"})
    public String check(HttpServletResponse response) {
        if (!this.inService) {
            response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
        }
        return this.inService ? "OK" : "INVALID";
    }

    @RequestMapping(value={"/monitor/stop"})
    public String stop(HttpServletRequest request) {
        if (!this.isLocalRequest(request)) {
            return "NO PERMISSION";
        }
        this.inService = false;
        return "OK";
    }

    @RequestMapping(value={"/monitor/start"})
    public String start(HttpServletRequest request) {
        if (!this.isLocalRequest(request)) {
            return "NO PERMISSION";
        }
        this.inService = true;
        return "OK";
    }

    private boolean isLocalRequest(HttpServletRequest request) {
        boolean isFromLocalIp = RequestTool.isLocalRequest((HttpServletRequest)request);
        if (!isFromLocalIp) {
            return false;
        }
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if (url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLocal;
    }
}

