/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.boot.ext.autoconfigure.web.ClientAbortExceptionIgnoreFilter;
import cn.com.duiba.boot.ext.autoconfigure.web.DBTimeProfileFilter;
import cn.com.duiba.wolf.utils.TestUtils;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.catalina.connector.ClientAbortException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;

@Configuration
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnWebApplication
public class WebMvcFixAutoConfiguration {
    @Bean(name={"viewResolver"})
    @ConditionalOnMissingBean(name={"viewResolver"}, value={ContentNegotiatingViewResolver.class})
    public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
        ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
        resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
        resolver.setOrder(Integer.MAX_VALUE);
        return resolver;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, InterruptedException {
        Cache cache = CacheBuilder.newBuilder().initialCapacity(1000000).expireAfterAccess(1000L, TimeUnit.SECONDS).build();
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 1000000L; ++i) {
            SessionConsumerDto dto = (SessionConsumerDto)TestUtils.createRandomBean(SessionConsumerDto.class);
            cache.put((Object)UUIDUtils.createUUID(), (Object)dto);
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
        System.out.println(cache.size());
        Thread.sleep(10000000L);
    }

    private static class SessionConsumerDto {
        private Long cid;
        private String partnerUserId;
        private Long time;
        private Long expireTime;

        private SessionConsumerDto() {
        }

        public Long getCid() {
            return this.cid;
        }

        public void setCid(Long cid) {
            this.cid = cid;
        }

        public String getPartnerUserId() {
            return this.partnerUserId;
        }

        public void setPartnerUserId(String partnerUserId) {
            this.partnerUserId = partnerUserId;
        }

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public Long getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(Long expireTime) {
            this.expireTime = expireTime;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class, ClientAbortException.class})
    @ConditionalOnWebApplication
    public static class ClientAbortExceptionIgnoreFilterConfiguration {
        @Bean
        public FilterRegistrationBean clientAbortExceptionIgnoreFilterConfigurer() {
            ClientAbortExceptionIgnoreFilter filter = new ClientAbortExceptionIgnoreFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(2);
            return registrationBean;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
    @ConditionalOnWebApplication
    public static class dbTimeProfileFilterConfiguration {
        @Bean
        public FilterRegistrationBean dbTimeProfileFilterConfigurer() {
            DBTimeProfileFilter filter = new DBTimeProfileFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-1);
            return registrationBean;
        }
    }
}

