/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.catmonitor.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CatSpringDataElasticSearchPlugin {
    private static final String space = "Elasticsearch";

    @Around(value="execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (CatInstance.isEnable()) {
            Transaction transaction = Cat.newTransaction((String)space, (String)methodName);
            try {
                Object obj = joinPoint.proceed();
                transaction.setStatus("0");
                Object object = obj;
                return object;
            }
            catch (Throwable e) {
                Cat.logError((Throwable)e);
                transaction.setStatus(e);
                throw e;
            }
            finally {
                transaction.complete();
            }
        }
        return joinPoint.proceed();
    }
}

