/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.initserver;

import com.alibaba.dubbo.rpc.service.EchoService;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.CannotGetJdbcConnectionException;

@Configuration
public class InitServerAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(InitServerAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class})
    public static class DataSourcePostProcessorConfiguration {
        @Bean
        public BeanPostProcessor dataSourcePostProcessorConfigurer() {
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    if (bean instanceof BasicDataSource) {
                        Connection conn = null;
                        try {
                            BasicDataSource dataSource = (BasicDataSource)bean;
                            conn = dataSource.getConnection();
                        }
                        catch (SQLException e) {
                            throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", e);
                        }
                        finally {
                            if (conn != null) {
                                try {
                                    conn.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                        }
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={EchoService.class})
    public static class DubboPostProcessorConfiguration {
        @Bean
        public BeanPostProcessor dubboPostProcessorConfigurer() {
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    if (bean instanceof EchoService) {
                        try {
                            EchoService echoService = (EchoService)bean;
                            echoService.$echo((Object)"OK");
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={ServletRegistrationBean.class})
    public static class WebPostProcessorConfiguration {
        @Bean
        public BeanPostProcessor webPostProcessorConfigurer() {
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    ServletRegistrationBean servlet;
                    if (bean instanceof ServletRegistrationBean && (servlet = (ServletRegistrationBean)bean).getServletName().equalsIgnoreCase("dispatcherServlet")) {
                        servlet.setLoadOnStartup(1);
                    }
                    return bean;
                }
            };
        }
    }
}

