/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.xss;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXSS(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return this.cleanXSS(value);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return this.cleanXSS(value);
    }

    private String cleanXSS(String value) {
        if (value == null) {
            return null;
        }
        value = StringUtils.replace((String)value, (String)"\\t", (String)" ");
        value = StringUtils.replace((String)value, (String)"\t", (String)" ");
        return StringEscapeUtils.escapeHtml3((String)value);
    }
}

