/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.boot.ext.autoconfigure.cat.CatMemcachePlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatRediscachePlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatSpringDataElasticSearchPlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatSpringDataMongodbPlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatSpringDataRedisPlugin;
import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duiba.catmonitor.mybatis.CatMybatisPlugin;
import cn.com.duiba.wolf.cache.XMemcacheClient;
import cn.com.duiba.wolf.redis.RedisClient;
import com.dianping.cat.Cat;
import com.dianping.cat.servlet.CatFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.rubyeye.xmemcached.MemcachedClient;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class CatAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Cat.class})
    public static class InitCatServer
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        public void onApplicationEvent(ContextRefreshedEvent arg0) {
            CatInstance.isEnable();
        }

        public int getOrder() {
            return -3;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ElasticsearchOperations.class, Cat.class, Aspect.class})
    public static class CatElasticsearchConfiguration {
        @Bean
        public CatSpringDataElasticSearchPlugin getCatSpringDataElasticSearchPlugin() {
            return new CatSpringDataElasticSearchPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoOperations.class, Cat.class, Aspect.class})
    public static class CatMongodbConfiguration {
        @Bean
        public CatSpringDataMongodbPlugin getCatSpringDataMongodbPlugin() {
            return new CatSpringDataMongodbPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={XMemcacheClient.class, MemcachedClient.class, Cat.class, Aspect.class})
    public static class CatMemcacheConfiguration {
        @Bean
        public CatMemcachePlugin getCatMemcachePlugin() {
            return new CatMemcachePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatSpringDataRedisAspectConfiguration {
        @Bean
        public CatSpringDataRedisPlugin catSpringDataRedisAspectPlugin() {
            return new CatSpringDataRedisPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisClient.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatRediscacheConfiguration {
        @Bean
        public CatRediscachePlugin getCatCachePlugin() {
            return new CatRediscachePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, CatMybatisPlugin.class})
    public static class MyBatisPostProcessorConfiguration {
        @Bean
        public SpecifiedBeanPostProcessor myBatisPostProcessorConfigurer() {
            return new SpecifiedBeanPostProcessor<Object>(){

                public int getOrder() {
                    return -1;
                }

                @Override
                public Class<Object> getBeanType() {
                    return Object.class;
                }

                @Override
                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    SqlSessionFactory s = null;
                    if (bean instanceof SqlSessionFactory) {
                        s = (SqlSessionFactory)bean;
                    }
                    if (bean instanceof SqlSessionTemplate) {
                        s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
                    }
                    if (s == null) {
                        return bean;
                    }
                    boolean hasCatPlugin = false;
                    if (s.getConfiguration().getInterceptors() != null && !s.getConfiguration().getInterceptors().isEmpty()) {
                        for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                            if (!(plugin instanceof CatMybatisPlugin)) continue;
                            hasCatPlugin = true;
                            break;
                        }
                    }
                    if (!hasCatPlugin) {
                        s.getConfiguration().addInterceptor((Interceptor)new CatMybatisPlugin());
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, FilterRegistrationBean.class, CatFilter.class})
    @ConditionalOnWebApplication
    public static class CatHttpFilterConfiguration {
        @Bean
        public FilterRegistrationBean catHttpFilterConfigurer() {
            CatFilter catFilter = new CatFilter(){

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                    String postfix;
                    HttpServletRequest req = (HttpServletRequest)request;
                    String uri = req.getRequestURI();
                    int index = uri.indexOf(46);
                    if (index > 0 && ((postfix = uri.substring(index).toLowerCase()).equals(".js") || postfix.equals(".gif") || postfix.equals(".jpg") || postfix.equals(".png") || postfix.equals(".css") || postfix.equals(".ico") || postfix.equals(".eot") || postfix.equals(".woff") || postfix.equals(".ttf") || postfix.equals(".svg"))) {
                        chain.doFilter(request, response);
                        return;
                    }
                    super.doFilter(request, response, chain);
                }
            };
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)catFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
            registrationBean.setOrder(1);
            return registrationBean;
        }
    }
}

