/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.initserver;

import cn.com.duiba.boot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.initserver.ApplicationListenerForAsyncSpecified;
import cn.com.duiba.boot.ext.autoconfigure.initserver.BeanPostProcessorOfSpecified;
import com.alibaba.dubbo.rpc.service.EchoService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import redis.clients.jedis.Jedis;

@Configuration
public class InitServerAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(InitServerAutoConfiguration.class);
    private Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap = new HashMap<AsyncSpecifiedBeanPostProcessor, Map<String, Object>>(10);

    @Bean
    public BeanPostProcessor specifiedBeanPostProcessorConfigurer(ApplicationContext applicationContext) {
        Map processorMap = applicationContext.getBeansOfType(SpecifiedBeanPostProcessor.class, false, false);
        ArrayList<SpecifiedBeanPostProcessor> processorList = new ArrayList<SpecifiedBeanPostProcessor>(processorMap.values());
        Collections.sort(processorList, new Comparator<SpecifiedBeanPostProcessor>(){

            @Override
            public int compare(SpecifiedBeanPostProcessor o1, SpecifiedBeanPostProcessor o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        Map asyncProcessorMap = applicationContext.getBeansOfType(AsyncSpecifiedBeanPostProcessor.class, false, false);
        ArrayList<AsyncSpecifiedBeanPostProcessor> asyncProcessorList = new ArrayList<AsyncSpecifiedBeanPostProcessor>(asyncProcessorMap.values());
        return new BeanPostProcessorOfSpecified(processorList, asyncProcessorList, this.asyncProcessor2BeansMap);
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> asyncSpecifiedBeanPostProcessorConfigurer(ApplicationContext applicationContext) {
        return new ApplicationListenerForAsyncSpecified(this.asyncProcessor2BeansMap);
    }

    @Configuration
    @ConditionalOnClass(value={MongoOperations.class})
    public static class MongoDbPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor mongoDbPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<MongoOperations>(){

                @Override
                public Class<MongoOperations> getBeanType() {
                    return MongoOperations.class;
                }

                @Override
                public void postProcessAfterInitialization(MongoOperations mongoOperations, String beanName) {
                    try {
                        mongoOperations.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)"1")), String.class, "test_collection");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={ElasticsearchOperations.class})
    public static class ElasticSearchPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor elasticSearchPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<ElasticsearchOperations>(){

                @Override
                public Class<ElasticsearchOperations> getBeanType() {
                    return ElasticsearchOperations.class;
                }

                @Override
                public void postProcessAfterInitialization(ElasticsearchOperations elasticsearchOperations, String beanName) {
                    elasticsearchOperations.indexExists("justForTest");
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    public static class RedisPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor redisPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<RedisTemplate>(){

                @Override
                public Class<RedisTemplate> getBeanType() {
                    return RedisTemplate.class;
                }

                @Override
                public void postProcessAfterInitialization(RedisTemplate redisTemplate, String beanName) {
                    redisTemplate.execute(new RedisCallback(){

                        public Object doInRedis(RedisConnection connection) throws DataAccessException {
                            Jedis jedis = (Jedis)connection.getNativeConnection();
                            return jedis.get("justForInitTest");
                        }
                    });
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={CannotGetJdbcConnectionException.class, BasicDataSource.class})
    public static class DataSourcePostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor dataSourcePostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<DataSource>(){

                @Override
                public Class<DataSource> getBeanType() {
                    return DataSource.class;
                }

                @Override
                public void postProcessAfterInitialization(DataSource dataSource, String beanName) {
                    Connection conn = null;
                    try {
                        conn = dataSource.getConnection();
                    }
                    catch (SQLException e) {
                        throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", e);
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={EchoService.class})
    public static class DubboPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor dubboPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<EchoService>(){

                @Override
                public Class<EchoService> getBeanType() {
                    return EchoService.class;
                }

                @Override
                public void postProcessAfterInitialization(EchoService echoService, String beanName) {
                    try {
                        echoService.$echo((Object)"OK");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={ServletRegistrationBean.class})
    public static class WebPostProcessorConfiguration {
        @Bean
        public SpecifiedBeanPostProcessor webPostProcessorConfigurer() {
            return new SpecifiedBeanPostProcessor<ServletRegistrationBean>(){

                public int getOrder() {
                    return 0;
                }

                @Override
                public Class<ServletRegistrationBean> getBeanType() {
                    return ServletRegistrationBean.class;
                }

                @Override
                public Object postProcessBeforeInitialization(ServletRegistrationBean bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(ServletRegistrationBean bean, String beanName) throws BeansException {
                    if (bean.getServletName().equalsIgnoreCase("dispatcherServlet")) {
                        bean.setLoadOnStartup(1);
                    }
                    return bean;
                }
            };
        }
    }
}

