/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.core.ttl.TransmittableExecutorBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
@ConditionalOnClass(value={TransmittableThreadLocal.class})
public class PerfTestAutoConfiguration {

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={AbstractRoutingDataSource.class, TransmittableThreadLocal.class})
    public static class DataSourceConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<DataSource>(){

                public int getOrder() {
                    return -2;
                }

                @Override
                public Class<DataSource> getBeanType() {
                    return DataSource.class;
                }

                @Override
                public Object postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                    if (!(bean instanceof PerfTestRoutingDataSource)) {
                        PerfTestRoutingDataSource ts = new PerfTestRoutingDataSource((DataSource)bean);
                        ts.afterPropertiesSet();
                        bean = ts;
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    public static class TransmittableThreadLocalConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestExecutorServiceBeanPostProcessor() {
            return new TransmittableExecutorBeanPostProcessor();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    @ConditionalOnWebApplication
    public static class WebConfiguration
    extends WebMvcConfigurerAdapter {
        public void addInterceptors(InterceptorRegistry registry) {
            try {
                Field field = registry.getClass().getDeclaredField("registrations");
                field.setAccessible(true);
                List registrations = (List)field.get(registry);
                for (InterceptorRegistration r : registrations) {
                    if (!(r instanceof InternalInterceptorRegistration)) continue;
                    return;
                }
                InternalInterceptorRegistration registration = new InternalInterceptorRegistration(this.pressureTestInterceptor());
                registration.addPathPatterns(new String[]{"/**"});
                if (registrations.isEmpty()) {
                    registrations.add(registration);
                } else {
                    registrations.add(0, registration);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private HandlerInterceptor pressureTestInterceptor() {
            return new HandlerInterceptorAdapter(){

                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
                    TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
                    boolean isTestMode = false;
                    String testInParameter = request.getParameter("_duibaPerf");
                    if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
                        isTestMode = true;
                    } else {
                        Cookie[] cookies = request.getCookies();
                        if (cookies != null) {
                            for (Cookie cookie : cookies) {
                                if (!"_duibaPerf".equals(cookie.getName()) || !"1".equals(cookie.getValue()) && !"true".equals(cookie.getValue())) continue;
                                isTestMode = true;
                            }
                        }
                    }
                    if (isTestMode) {
                        TransmittableThreadLocalHolder.threadLocal2PressureTest.set((Object)true);
                    }
                    return true;
                }

                public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
                    TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
                }
            };
        }

        private class InternalInterceptorRegistration
        extends InterceptorRegistration {
            public InternalInterceptorRegistration(HandlerInterceptor interceptor) {
                super(interceptor);
            }
        }
    }

    public static class TransmittableThreadLocalHolder {
        protected static final TransmittableThreadLocal<Boolean> threadLocal2PressureTest = new TransmittableThreadLocal();
    }
}

