/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.ext.autoconfigure.perftest.PerfTestAutoConfiguration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.Assert;

public class PerfTestRoutingDataSource
extends AbstractRoutingDataSource
implements DisposableBean {
    private static final String ORIGINAL_DATASOURCE = "original";
    private static final String TEST_DATASOURCE = "test";
    private static final String TEST_SCHEME_PREFIX = "perf__";
    private volatile boolean hasTestDataSource = false;
    private volatile boolean testDataSourceInitted = false;
    private String originalScheme;
    private BasicDataSource originalDataSource;
    private BasicDataSource shadeDataSource;
    private ConcurrentMap<Object, Object> targetDataSources = new ConcurrentHashMap<Object, Object>();
    private boolean thisInitted = false;

    public PerfTestRoutingDataSource(DataSource originalDataSource) {
        if (!(originalDataSource instanceof BasicDataSource)) {
            throw new IllegalStateException("\u59ab\ufffd\u5a34\u5b2a\u57cc\u93c8\u5842ataSource\u5a0c\u2103\u6e41\u6d63\u8de8\u6564dbcp2\u951b\u5c83\ue1ec\u934f\u581f\u657c\u93b4\u6049bcp2\u9286\ufffd");
        }
        this.originalDataSource = (BasicDataSource)originalDataSource;
    }

    public void afterPropertiesSet() {
        if (this.thisInitted) {
            return;
        }
        this.thisInitted = true;
        this.targetDataSources.put(ORIGINAL_DATASOURCE, this.originalDataSource);
        String originalUrl = this.originalDataSource.getUrl();
        this.originalScheme = this.getOriginalScheme(originalUrl);
        super.setTargetDataSources(this.targetDataSources);
        super.afterPropertiesSet();
    }

    private BasicDataSource getTestDataSource(BasicDataSource originalDataSource) {
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        HashSet<String> schemes = new HashSet<String>();
        try {
            connection = originalDataSource.getConnection();
            statement = connection.createStatement();
            rs = statement.executeQuery("show databases");
            while (rs.next()) {
                schemes.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        String testScheme = TEST_SCHEME_PREFIX + this.originalScheme;
        if (!schemes.contains(testScheme)) {
            return null;
        }
        String testUrl = this.getTestUrl(originalDataSource.getUrl());
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(originalDataSource.getDriverClassName());
        ds.setUrl(testUrl);
        ds.setUsername(originalDataSource.getUsername());
        ds.setPassword(originalDataSource.getPassword());
        ds.setDefaultQueryTimeout(originalDataSource.getDefaultQueryTimeout());
        ds.setInitialSize(originalDataSource.getInitialSize());
        ds.setLogAbandoned(originalDataSource.getLogAbandoned());
        ds.setMaxIdle(originalDataSource.getMaxIdle());
        ds.setMaxTotal(originalDataSource.getMaxTotal());
        ds.setMinIdle(originalDataSource.getMinIdle());
        ds.setSoftMinEvictableIdleTimeMillis(originalDataSource.getSoftMinEvictableIdleTimeMillis());
        ds.setValidationQuery(originalDataSource.getValidationQuery());
        ds.setValidationQueryTimeout(originalDataSource.getValidationQueryTimeout());
        ds.setTimeBetweenEvictionRunsMillis(originalDataSource.getTimeBetweenEvictionRunsMillis());
        ds.setTestWhileIdle(originalDataSource.getTestWhileIdle());
        ds.setTestOnBorrow(originalDataSource.getTestOnBorrow());
        ds.setTestOnReturn(originalDataSource.getTestOnReturn());
        ds.setTestOnCreate(originalDataSource.getTestOnCreate());
        ds.setMaxWaitMillis(originalDataSource.getMaxWaitMillis());
        ds.setNumTestsPerEvictionRun(originalDataSource.getNumTestsPerEvictionRun());
        ds.setRemoveAbandonedOnBorrow(originalDataSource.getRemoveAbandonedOnBorrow());
        ds.setRemoveAbandonedOnMaintenance(originalDataSource.getRemoveAbandonedOnMaintenance());
        ds.setRemoveAbandonedTimeout(originalDataSource.getRemoveAbandonedTimeout());
        return ds;
    }

    private String getTestUrl(String originalUrl) {
        int index = originalUrl.lastIndexOf("/");
        if (index > 0) {
            return originalUrl.substring(0, index + 1) + TEST_SCHEME_PREFIX + originalUrl.substring(index + 1, originalUrl.length());
        }
        throw new IllegalArgumentException(originalUrl + " is invalid");
    }

    private String getOriginalScheme(String originalUrl) {
        int index = originalUrl.lastIndexOf("/");
        if (index > 0) {
            String schemeAfter = originalUrl.substring(index + 1, originalUrl.length());
            int index1 = schemeAfter.indexOf("?");
            if (index1 > 0) {
                return schemeAfter.substring(0, index1);
            }
            return schemeAfter;
        }
        throw new IllegalArgumentException(originalUrl + " is invalid");
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.targetDataSources, (String)"DataSource router not initialized");
        Object lookupKey = this.determineCurrentLookupKey();
        DataSource dataSource = (DataSource)this.targetDataSources.get(lookupKey);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected Object determineCurrentLookupKey() {
        Boolean isTestMode = (Boolean)PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        if (isTestMode != null && isTestMode.booleanValue()) {
            if (!this.testDataSourceInitted) {
                this.initTestDataSource();
            }
            if (!this.hasTestDataSource) {
                throw new IllegalStateException(this.originalScheme + "\u9428\u52eb\u5956\u701b\u612c\u7c31\u6d93\u5d85\u74e8\u9366\ue7d2\u7d1d\u93c0\u60e7\u7d14\u93c8\ue101\ue0bc\u7487\u950b\u7730");
            }
            return TEST_DATASOURCE;
        }
        return ORIGINAL_DATASOURCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTestDataSource() {
        PerfTestRoutingDataSource perfTestRoutingDataSource = this;
        synchronized (perfTestRoutingDataSource) {
            if (!this.testDataSourceInitted) {
                BasicDataSource testDataSource = this.getTestDataSource(this.originalDataSource);
                if (testDataSource != null) {
                    this.hasTestDataSource = true;
                    this.shadeDataSource = testDataSource;
                    this.targetDataSources.putIfAbsent(TEST_DATASOURCE, testDataSource);
                } else {
                    this.logger.warn((Object)(this.originalScheme + " \u5a0c\u2103\u6e41\u7035\u7470\u7c32\u9428\u52eb\u5956\u701b\u612d\u669f\u93b9\ue1bc\u7c31\u951b\u581d\u6e6a\u935a\u5c7c\u91dc\u6434\u64b2\u8151\u6d60\ue676erf__\u5bee\ufffd\u6fb6\u5bf8\u6b91scheme\u951b\u591b\u7d1d\u6fe1\u509b\u7049\u6d63\u72bb\u53a4\u7f03\ue1bb\u7c21\u951b\u5c84\u6e36\u7455\u4f80\u5678\u935a\ue21b\u6e70\u6434\u65c2\u6564\u9422\u71b8\u6665"));
                }
                this.testDataSourceInitted = true;
            }
        }
    }

    public void destroy() throws Exception {
        if (this.targetDataSources != null) {
            for (Object object : this.targetDataSources.values()) {
                try {
                    if (object instanceof BasicDataSource) {
                        ((BasicDataSource)object).close();
                        continue;
                    }
                    if (!(object instanceof AutoCloseable)) continue;
                    ((AutoCloseable)object).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public BasicDataSource getOriginalDataSource() {
        return this.originalDataSource;
    }

    public BasicDataSource getShadeDataSource() {
        return this.shadeDataSource;
    }
}

