/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.rocketmq;

import cn.com.duiba.boot.ext.autoconfigure.rocketmq.RocketMqProperties;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RocketMqProperties.class})
public class RocketMqAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RocketMqAutoConfiguration.class);

    private static class RocketMqConsumerFactoryBean
    implements FactoryBean<DefaultMQPushConsumer>,
    InitializingBean,
    DisposableBean {
        @Autowired(required=false)
        @Qualifier(value="bootRocketMqMessageListener")
        private MessageListener rocketMqMessageListener;
        private DefaultMQPushConsumer rocketMqConsumer;
        private RocketMqProperties rocketMqProperties;

        public RocketMqConsumerFactoryBean(RocketMqProperties rocketMqProperties) {
            this.rocketMqProperties = rocketMqProperties;
        }

        public void afterPropertiesSet() throws Exception {
            String[] topicArr;
            if (this.rocketMqMessageListener == null) {
                logger.error("", (Throwable)new IllegalStateException("bean id:[bootRocketMqMessageListener] class:[org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently] is not exist in spring's context, \u7487\u5cf0\uff10\u93c4\u5eaf\u7d1d\u935a\ufe40\u57af\u6d93\u5d84\u7d30\u935a\ue21c\u6564rocketmq\u5a11\u5823\u5782!!!\u951b\u5c83\ue1ec\u9359\u509d\ufffd\ufffd: http://cf.dui88.com/pages/viewpage.action?pageId=5256828"));
                return;
            }
            DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(this.rocketMqProperties.getConsumer().getGroup());
            consumer.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddr());
            consumer.setMaxReconsumeTimes(this.rocketMqProperties.getConsumer().getMaxReconsumeTimes().intValue());
            if (this.rocketMqProperties.getConsumer().getConsumeThreadNums() > 0) {
                consumer.setConsumeThreadMin(this.rocketMqProperties.getConsumer().getConsumeThreadNums().intValue());
                consumer.setConsumeThreadMax(Math.max(this.rocketMqProperties.getConsumer().getConsumeThreadNums(), 64));
            }
            consumer.setConsumeMessageBatchMaxSize(1);
            String topics = this.rocketMqProperties.getConsumer().getTopics();
            for (String topic : topicArr = topics.split(",")) {
                consumer.subscribe(topic, "*");
            }
            if (this.rocketMqMessageListener instanceof MessageListenerConcurrently) {
                consumer.registerMessageListener((MessageListenerConcurrently)this.rocketMqMessageListener);
            } else if (this.rocketMqMessageListener instanceof MessageListenerOrderly) {
                consumer.registerMessageListener((MessageListenerOrderly)this.rocketMqMessageListener);
            }
            consumer.start();
            this.rocketMqConsumer = consumer;
        }

        public DefaultMQPushConsumer getObject() throws Exception {
            return this.rocketMqConsumer;
        }

        public Class<?> getObjectType() {
            return DefaultMQPushConsumer.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public void destroy() throws Exception {
            this.rocketMqConsumer.shutdown();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQPushConsumer.class})
    @ConditionalOnMissingBean(name={"rocketMqConsumer"})
    @ConditionalOnProperty(name={"duiba.rocketmq.consumer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class RocketMqConsumerConfigurator
    extends RocketMqClientConfiguration {
        protected RocketMqConsumerConfigurator() {
        }

        @Bean(name={"rocketMqConsumer"})
        public FactoryBean<DefaultMQPushConsumer> rocketMqConsumer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return new RocketMqConsumerFactoryBean(this.rocketMqProperties);
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(name={"rocketMqProducer"})
    @ConditionalOnProperty(name={"duiba.rocketmq.producer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class RocketMqProducerConfigurator
    extends RocketMqClientConfiguration {
        protected RocketMqProducerConfigurator() {
        }

        @Bean(name={"rocketMqProducer"}, destroyMethod="shutdown")
        public DefaultMQProducer rocketMqProducer() throws MQClientException {
            DefaultMQProducer p = new DefaultMQProducer();
            p.setProducerGroup(this.rocketMqProperties.getProducer().getGroup());
            p.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddr());
            p.setSendMsgTimeout(this.rocketMqProperties.getProducer().getSendMsgTimeoutMillis().intValue());
            p.start();
            return p;
        }
    }

    protected static abstract class RocketMqClientConfiguration {
        @Autowired
        protected RocketMqProperties rocketMqProperties;

        protected RocketMqClientConfiguration() {
        }
    }
}

