/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.catmonitor.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CatMemcachePlugin {
    @Around(value="execution(* cn.com.duiba.wolf.cache.XMemcacheClient.*(..))")
    public Object memcachedJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (CatInstance.isEnable()) {
            Transaction transaction = null;
            transaction = "get".equals(methodName) ? Cat.newTransaction((String)"Cache.memcached", (String)(methodName + ":" + methodName)) : Cat.newTransaction((String)"Cache.memcached", (String)methodName);
            try {
                Object cacheValue = joinPoint.proceed();
                if ("get".equals(methodName) && cacheValue == null) {
                    Cat.logEvent((String)"Cache.memcached", (String)(methodName + ":missed"));
                }
                transaction.setStatus("0");
                Object object = cacheValue;
                return object;
            }
            catch (Throwable e) {
                Cat.logError((Throwable)e);
                transaction.setStatus(e);
                throw e;
            }
            finally {
                transaction.complete();
            }
        }
        return joinPoint.proceed();
    }
}

