/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.ons;

import cn.com.duiba.boot.ext.autoconfigure.ons.OnsProperties;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OnsProperties.class})
public class OnsAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OnsAutoConfiguration.class);

    private static class OnsConsumerFactoryBean
    implements FactoryBean<Consumer>,
    InitializingBean,
    DisposableBean {
        @Autowired(required=false)
        @Qualifier(value="bootOnsMessageListener")
        private MessageListener onsMessageListener;
        private Consumer onsConsumer;
        private OnsProperties onsProperties;

        public OnsConsumerFactoryBean(OnsProperties onsProperties) {
            this.onsProperties = onsProperties;
        }

        public void afterPropertiesSet() throws Exception {
            String[] topicArr;
            if (this.onsMessageListener == null) {
                logger.error("", (Throwable)new IllegalStateException("bean id:[bootOnsMessageListener] class:[com.aliyun.openservices.ons.api.MessageListener] is not exist in spring's context, \u7487\u5cf0\uff10\u93c4\u5eaf\u7d1d\u935a\ufe40\u57af\u6d93\u5d84\u7d30\u935a\ue21c\u6564ons\u5a11\u5823\u5782!!!,\u7487\u5cf0\u5f2c\u9470\u51bf\u7d30 http://cf.dui88.com/pages/viewpage.action?pageId=4493915"));
                return;
            }
            Properties properties = new Properties();
            properties.put("ConsumerId", this.onsProperties.getConsumer().getGroup());
            properties.put("AccessKey", this.onsProperties.getAccessKey());
            properties.put("SecretKey", this.onsProperties.getSecretKey());
            properties.put("maxReconsumeTimes", this.onsProperties.getConsumer().getMaxReconsumeTimes());
            if (this.onsProperties.getNameSrvAddr() != null) {
                properties.put("NAMESRV_ADDR", this.onsProperties.getNameSrvAddr());
            }
            if (this.onsProperties.getConsumer().getConsumeThreadNums() > 0) {
                properties.put("ConsumeThreadNums", this.onsProperties.getConsumer().getConsumeThreadNums());
            }
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            String topics = this.onsProperties.getConsumer().getTopics();
            for (String topic : topicArr = topics.split(",")) {
                consumer.subscribe(topic, "*", this.onsMessageListener);
            }
            consumer.start();
            this.onsConsumer = consumer;
        }

        public Consumer getObject() throws Exception {
            return this.onsConsumer;
        }

        public Class<?> getObjectType() {
            return Consumer.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public void destroy() throws Exception {
            this.onsConsumer.shutdown();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Consumer.class})
    @ConditionalOnMissingBean(name={"onsConsumer"})
    @ConditionalOnProperty(name={"duiba.ons.consumer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class OnsConsumerConfigurator
    extends OnsClientConfiguration {
        protected OnsConsumerConfigurator() {
        }

        @Bean(name={"onsConsumer"})
        public FactoryBean<Consumer> onsConsumer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return new OnsConsumerFactoryBean(this.onsProperties);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Producer.class})
    @ConditionalOnMissingBean(name={"onsProducer"})
    @ConditionalOnProperty(name={"duiba.ons.producer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class OnsProducerConfigurator
    extends OnsClientConfiguration {
        protected OnsProducerConfigurator() {
        }

        @Bean(name={"onsProducer"}, destroyMethod="shutdown")
        public Producer onsProducer() {
            Properties properties = new Properties();
            String producerId = this.onsProperties.getProducer().getGroup();
            if (producerId != null && !producerId.equals("")) {
                properties.put("ProducerId", producerId);
            }
            properties.put("AccessKey", this.onsProperties.getAccessKey());
            properties.put("SecretKey", this.onsProperties.getSecretKey());
            properties.put("SendMsgTimeoutMillis", this.onsProperties.getProducer().getSendMsgTimeoutMillis());
            if (this.onsProperties.getNameSrvAddr() != null) {
                properties.put("NAMESRV_ADDR", this.onsProperties.getNameSrvAddr());
            }
            Producer producer = ONSFactory.createProducer((Properties)properties);
            producer.start();
            return producer;
        }
    }

    protected static abstract class OnsClientConfiguration {
        @Autowired
        protected OnsProperties onsProperties;

        protected OnsClientConfiguration() {
        }
    }
}

