/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.security;

import java.io.FileDescriptor;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.sql.SQLPermission;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.LoggingPermission;
import javax.security.auth.AuthPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

@Configuration
public class SecurityManagerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SecurityManagerAutoConfiguration.class);
    static Set<String> forbiddenPermNames = new HashSet<String>(10);

    private static boolean conditionalOnMissingClass(String ... classNames) {
        boolean existsOne = false;
        for (String className : classNames) {
            try {
                Class.forName(className);
                existsOne = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return !existsOne;
    }

    static {
        forbiddenPermNames.add("queuePrintJob");
        if (SecurityManagerAutoConfiguration.conditionalOnMissingClass("org.junit.Test", "org.testng.annotations.Test")) {
            forbiddenPermNames.add("setIO");
            forbiddenPermNames.add("setSecurityManager");
        } else {
            logger.warn("\u6e1a\ufe3d\u7974\u9352\u677f\u6e6a\u5a34\u5b2d\u762f\u59af\u2033\u7d21, SecurityManager\u934f\u4f7d\ue18f\u93c9\u51ae\u6aba:[setIO/setSecurityManager],\u6fe1\u509b\u7049\u6d63\u8de8\u6564java -jar\u6769\u612f\ue511\u93c3\u8bb9\u7d19\u95c8\u70b4\u7974\u7487\u66df\u0101\u5bee\u5fe5\u7d1a\u942a\u5b2a\u57cc\u6769\u6b10\u6f6f\u93c3\u30e5\u7e54\u951b\u5c83\ue1ec\u7ead\ue1bb\u7e5a\u93b6\u5980unit/testng/spring-test\u7edb\u590b\u7974\u7487\u66df\ue50b\u93cb\u60f0\ue195\u7f03\ue1bb\u8d1ftestCompile\u6e1a\u6fca\u7986\u59af\u2033\u7d21\u951b\u581d\u5d46\u93b5\u64b6\u6b91jar\u9356\u546c\u8151\u6d93\u5d88\ue6e6\u9356\u546d\u60c8junit/testng\u9428\u522far\u9356\u5483\u7d1a");
        }
    }

    @Configuration
    public static class DuibaSecurityManagerConfiguarApplicationListener
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        private boolean flag = true;

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (this.flag) {
                if (System.getSecurityManager() == null) {
                    System.setSecurityManager(new SecurityManager(){

                        @Override
                        public void checkExec(String cmd) {
                            super.checkExec(cmd);
                        }

                        @Override
                        public void checkCreateClassLoader() {
                        }

                        @Override
                        public void checkRead(String file) {
                        }

                        @Override
                        public void checkRead(String file, Object context) {
                        }

                        @Override
                        public void checkWrite(String file) {
                        }

                        @Override
                        public void checkDelete(String file) {
                        }

                        @Override
                        public void checkPackageAccess(String pkg) {
                        }

                        @Override
                        public void checkAccess(Thread t) {
                        }

                        @Override
                        public void checkAccess(ThreadGroup g) {
                        }

                        public void checkMemberAccess(Class<?> clazz, int which) {
                            String className = clazz.getName();
                            if (className.equals("java.lang.ProcessImpl") || className.equals("java.lang.UNIXProcess") || className.equals("java.lang.ProcessBuilder")) {
                                throw new AccessControlException("not allowed to reflect access class:" + className);
                            }
                        }

                        @Override
                        public void checkPermission(Permission perm) {
                            FilePermission fp;
                            if (perm instanceof AllPermission || perm instanceof PropertyPermission || perm instanceof SerializablePermission || perm instanceof ReflectPermission || perm instanceof NetPermission || perm instanceof SQLPermission || perm instanceof SecurityPermission || perm instanceof LoggingPermission || perm instanceof AuthPermission || perm instanceof SocketPermission) {
                                return;
                            }
                            if (perm instanceof FilePermission && (fp = (FilePermission)perm).getActions().equals("execute")) {
                                super.checkPermission(perm);
                                return;
                            }
                            if (forbiddenPermNames.contains(perm.getName())) {
                                super.checkPermission(perm);
                                return;
                            }
                        }

                        @Override
                        public void checkPermission(Permission perm, Object context) {
                        }

                        @Override
                        public void checkExit(int status) {
                        }

                        @Override
                        public void checkLink(String lib) {
                        }

                        @Override
                        public void checkRead(FileDescriptor fd) {
                        }

                        @Override
                        public void checkWrite(FileDescriptor fd) {
                        }

                        @Override
                        public void checkConnect(String host, int port) {
                        }

                        @Override
                        public void checkConnect(String host, int port, Object context) {
                        }

                        @Override
                        public void checkListen(int port) {
                        }

                        @Override
                        public void checkAccept(String host, int port) {
                        }

                        @Override
                        public void checkMulticast(InetAddress maddr) {
                        }

                        @Override
                        public void checkMulticast(InetAddress maddr, byte ttl) {
                        }

                        @Override
                        public void checkPropertiesAccess() {
                        }

                        @Override
                        public void checkPropertyAccess(String key) {
                        }

                        @Override
                        public void checkPackageDefinition(String pkg) {
                        }

                        @Override
                        public void checkSetFactory() {
                        }

                        @Override
                        public void checkSecurityAccess(String target) {
                        }
                    });
                }
                this.flag = false;
            }
        }

        public int getOrder() {
            return -10;
        }
    }
}

