/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web.cookie;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;

public class Rfc2109CookieFixHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private boolean cookieFixed = false;

    public Rfc2109CookieFixHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = super.getCookies();
        this.fixCookie(cookies);
        return cookies;
    }

    private void fixCookie(Cookie[] cookies) {
        if (this.cookieFixed) {
            return;
        }
        this.cookieFixed = true;
        String cookieHeader = StringUtils.trimToEmpty((String)this.getHeader("Cookie"));
        if (cookieHeader.startsWith("$Version=\"1\"") || cookieHeader.startsWith("$Version=1")) {
            for (Cookie c : cookies) {
                String val = c.getValue();
                if (val == null || !val.startsWith("\"") || !val.endsWith("\"")) continue;
                val = val.substring(1, val.length() - 1);
                c.setValue(val);
            }
        }
    }
}

