/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.boot.ext.autoconfigure.cat.CatMemcachePlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatRediscachePlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatSpringDataElasticSearchPlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatSpringDataMongodbPlugin;
import cn.com.duiba.boot.ext.autoconfigure.cat.CatSpringDataRedisPlugin;
import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duiba.catmonitor.mybatis.CatMybatisPlugin;
import cn.com.duiba.wolf.cache.XMemcacheClient;
import cn.com.duiba.wolf.redis.RedisClient;
import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.store.DataStore;
import com.alibaba.dubbo.registry.dubbo.DubboRegistry;
import com.dianping.cat.Cat;
import com.dianping.cat.servlet.CatFilter;
import com.dianping.cat.status.StatusExtension;
import com.dianping.cat.status.StatusExtensionRegister;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.rubyeye.xmemcached.MemcachedClient;
import org.apache.catalina.startup.Tomcat;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class CatAutoConfiguration {
    private static final String ThreadPoolWaterLevelId = "\u7efe\u8de8\u25bc\u59f9\u72b3\u6309\u6d63\u5d85\u6d58";

    @Configuration
    @ConditionalOnClass(value={CatFilter.class})
    public static class DubiaBizThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    Initializable,
    ApplicationListener<ContextRefreshedEvent> {
        private ThreadPoolExecutorWrapper executorService;
        private ScheduledThreadPoolExecutorWrapper scheduledExecutorService;

        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u935a\u52ea\u91dc\u7efe\u8de8\u25bc\u59f9\u72b5\u6b91\u59d8\u7fe0\u7d85\u9429\u621e\u5e36\u8e47\u51ad\u70e6";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            if (this.executorService != null) {
                maps.put("DuibaBiz-ActiveCount(core:" + this.executorService.getCorePoolSize() + ",max:" + this.executorService.getMaximumPoolSize() + ")", String.valueOf(this.executorService.getActiveCount()));
            }
            if (this.scheduledExecutorService != null) {
                maps.put("DuibaBizScheduled-ActiveCount(core:" + this.scheduledExecutorService.getCorePoolSize() + ",max:" + this.scheduledExecutorService.getMaximumPoolSize() + ")", String.valueOf(this.scheduledExecutorService.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() throws InitializationException {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            ApplicationContext applicationContext = event.getApplicationContext();
            try {
                Object executorService = applicationContext.getBean("executorService");
                if (executorService != null && executorService instanceof ThreadPoolExecutorWrapper) {
                    this.executorService = (ThreadPoolExecutorWrapper)executorService;
                }
            }
            catch (Exception executorService) {
                // empty catch block
            }
            try {
                Object scheduledExecutorService = applicationContext.getBean("scheduledExecutorService");
                if (scheduledExecutorService != null && scheduledExecutorService instanceof ScheduledThreadPoolExecutorWrapper) {
                    this.scheduledExecutorService = (ScheduledThreadPoolExecutorWrapper)scheduledExecutorService;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.executorService != null || this.scheduledExecutorService != null) {
                StatusExtensionRegister.getInstance().register((StatusExtension)this);
            }
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={TomcatEmbeddedServletContainerFactory.class, Tomcat.class, Servlet.class, CatFilter.class})
    public static class HttpThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    Initializable,
    ApplicationListener<EmbeddedServletContainerInitializedEvent> {
        private ThreadPoolExecutor httpThreadPool;

        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u935a\u52ea\u91dc\u7efe\u8de8\u25bc\u59f9\u72b5\u6b91\u59d8\u7fe0\u7d85\u9429\u621e\u5e36\u8e47\u51ad\u70e6";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            if (this.httpThreadPool != null) {
                maps.put("Http-ActiveCount(core:" + this.httpThreadPool.getCorePoolSize() + ",max:" + this.httpThreadPool.getMaximumPoolSize() + ")", String.valueOf(this.httpThreadPool.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() throws InitializationException {
        }

        public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
            EmbeddedServletContainer c = event.getEmbeddedServletContainer();
            if (!(c instanceof TomcatEmbeddedServletContainer)) {
                return;
            }
            TomcatEmbeddedServletContainer container = (TomcatEmbeddedServletContainer)c;
            Executor es = container.getTomcat().getConnector().getProtocolHandler().getExecutor();
            if (!(es instanceof ThreadPoolExecutor)) {
                return;
            }
            this.httpThreadPool = (ThreadPoolExecutor)es;
            StatusExtensionRegister.getInstance().register((StatusExtension)this);
        }
    }

    @Configuration
    @ConditionalOnClass(value={DubboRegistry.class, DataStore.class, CatFilter.class})
    public static class DubboThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    Initializable {
        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u935a\u52ea\u91dc\u7efe\u8de8\u25bc\u59f9\u72b5\u6b91\u59d8\u7fe0\u7d85\u9429\u621e\u5e36\u8e47\u51ad\u70e6";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
            Map executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
            for (Map.Entry entry : executors.entrySet()) {
                String port = (String)entry.getKey();
                ExecutorService executor = (ExecutorService)entry.getValue();
                if (executor == null || !(executor instanceof ThreadPoolExecutor)) continue;
                ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
                String portStr = executors.size() == 1 ? "" : "port:" + port + ",";
                maps.put("Dubbo-ActiveCount(" + portStr + "core:" + tp.getCorePoolSize() + ",max:" + tp.getMaximumPoolSize() + ")", String.valueOf(tp.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() throws InitializationException {
            StatusExtensionRegister.getInstance().register((StatusExtension)this);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Cat.class})
    public static class InitCatServer
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        public void onApplicationEvent(ContextRefreshedEvent arg0) {
            CatInstance.isEnable();
        }

        public int getOrder() {
            return -3;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ElasticsearchOperations.class, Cat.class, Aspect.class})
    public static class CatElasticsearchConfiguration {
        @Bean
        public CatSpringDataElasticSearchPlugin getCatSpringDataElasticSearchPlugin() {
            return new CatSpringDataElasticSearchPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoOperations.class, Cat.class, Aspect.class})
    public static class CatMongodbConfiguration {
        @Bean
        public CatSpringDataMongodbPlugin getCatSpringDataMongodbPlugin() {
            return new CatSpringDataMongodbPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={XMemcacheClient.class, MemcachedClient.class, Cat.class, Aspect.class})
    public static class CatMemcacheConfiguration {
        @Bean
        public CatMemcachePlugin getCatMemcachePlugin() {
            return new CatMemcachePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatSpringDataRedisAspectConfiguration {
        @Bean
        public CatSpringDataRedisPlugin catSpringDataRedisAspectPlugin() {
            return new CatSpringDataRedisPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisClient.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatRediscacheConfiguration {
        @Bean
        public CatRediscachePlugin getCatCachePlugin() {
            return new CatRediscachePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, CatMybatisPlugin.class, Cat.class})
    public static class MyBatisPostProcessorConfiguration {
        @Bean
        public SpecifiedBeanPostProcessor myBatisPostProcessorConfigurer() {
            return new SpecifiedBeanPostProcessor<Object>(){

                public int getOrder() {
                    return -1;
                }

                @Override
                public Class<Object> getBeanType() {
                    return Object.class;
                }

                @Override
                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    SqlSessionFactory s = null;
                    if (bean instanceof SqlSessionFactory) {
                        s = (SqlSessionFactory)bean;
                    }
                    if (bean instanceof SqlSessionTemplate) {
                        s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
                    }
                    if (s == null) {
                        return bean;
                    }
                    boolean hasCatPlugin = false;
                    if (s.getConfiguration().getInterceptors() != null && !s.getConfiguration().getInterceptors().isEmpty()) {
                        for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                            if (!(plugin instanceof CatMybatisPlugin)) continue;
                            hasCatPlugin = true;
                            break;
                        }
                    }
                    if (!hasCatPlugin) {
                        s.getConfiguration().addInterceptor((Interceptor)new CatMybatisPlugin());
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, FilterRegistrationBean.class, CatFilter.class})
    @ConditionalOnWebApplication
    public static class CatHttpFilterConfiguration {
        @Bean
        public FilterRegistrationBean catHttpFilterConfigurer() {
            CatFilter catFilter = new CatFilter(){

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                    String postfix;
                    HttpServletRequest req = (HttpServletRequest)request;
                    String uri = req.getRequestURI();
                    int index = uri.indexOf(46);
                    if (index > 0 && ((postfix = uri.substring(index).toLowerCase()).equals(".js") || postfix.equals(".gif") || postfix.equals(".jpg") || postfix.equals(".png") || postfix.equals(".css") || postfix.equals(".ico") || postfix.equals(".eot") || postfix.equals(".woff") || postfix.equals(".ttf") || postfix.equals(".svg"))) {
                        chain.doFilter(request, response);
                        return;
                    }
                    super.doFilter(request, response, chain);
                }
            };
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)catFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
            registrationBean.setOrder(1);
            return registrationBean;
        }
    }
}

