/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.mybatis;

import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.mybatis.SpringBootVFS;
import java.lang.reflect.Method;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MybatisAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, VFS.class})
    public static class MyBatisBugfixPostProcessorConfiguration {
        @Bean
        public SpecifiedBeanPostProcessor mybatisBugfixPostProcessorConfigurer() {
            boolean hasVfsMethod = false;
            try {
                Method m = SqlSessionFactoryBean.class.getMethod("getVfs", new Class[0]);
                hasVfsMethod = true;
            }
            catch (NoSuchMethodException e) {
                logger.warn("method[org.mybatis.spring.SqlSessionFactoryBean.getVfs()] is not exist, \u93c3\u72b3\u7876\u9477\ue044\u59e9\u6dc7\ue1bc\ue632mybatis\u9428\u5221ug\u951b\u5c83\ue1ec\u9357\u56e9\u9a87mybatis-spring\u9352\ufffd1.3.0\u93b4\u6826\u4e92\u6d93\u5a44\u5897\u93c8\ufffd");
            }
            final boolean hasVfsMethodFinal = hasVfsMethod;
            return new SpecifiedBeanPostProcessor<SqlSessionFactoryBean>(){

                public int getOrder() {
                    return -1;
                }

                @Override
                public Class<SqlSessionFactoryBean> getBeanType() {
                    return SqlSessionFactoryBean.class;
                }

                @Override
                public Object postProcessBeforeInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                    if (hasVfsMethodFinal && bean.getVfs() == null) {
                        bean.setVfs(SpringBootVFS.class);
                    }
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                    return bean;
                }
            };
        }
    }
}

