package cn.com.duiba.boot.ext.autoconfigure.logger.logback;


import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by liqing on 2017/8/16.
 */

/**
 * used to control ImmediateFlush frequency
 */
public class TimingLayoutEncoder extends PatternLayoutEncoder {
    private Timer timer = new Timer();
    private static final int intevalPeriod = 60 * 1000;//second
    private static final int timeDelay = 60 * 1000;

    public TimingLayoutEncoder(){
        this.start();
    }

    public void start() {
        timer.schedule(timerTask,timeDelay,intevalPeriod);
        super.start();
    }

    private TimerTask timerTask = new TimerTask() {
        @Override
        public void run(){

            if(outputStream != null)
                try {
                    outputStream.flush();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
        }
    };

}
