package cn.com.duibaboot.ext.autoconfigure.javaagent;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.AbstractClassEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginBootstrap;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginFinder;
import net.bytebuddy.agent.Installer;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.instrument.Instrumentation;

/**
 * 查找agent-plugin下配置的插件进行拦截,注入代码到相应的类(这个类必须被AppClassLoader加载，否则会报错)
 */
public class PluginAgent {
    private static final Logger logger = LoggerFactory.getLogger(PluginAgent.class.getName());
    private static final String INSTRUMENTATION_FIELD_NAME = "instrumentation";

    public static void agentmain(String args, Instrumentation instrumentation) {
        final PluginFinder pluginFinder = new PluginFinder(new PluginBootstrap().loadPlugins());
        new AgentBuilder.Default()
                .ignore(ElementMatchers.nameStartsWith("net.bytebuddy.")
                        .or(ElementMatchers.nameStartsWith("net.sf.cglib."))
                        .or(ElementMatchers.nameStartsWith("net."))
                        .or(ElementMatchers.nameStartsWith("org.objectweb.asm."))
                        .or(ElementMatchers.nameStartsWith("java."))
                        .or(ElementMatchers.nameStartsWith("sun."))
                        .or(ElementMatchers.nameStartsWith("com.sun."))
                        .or(ElementMatchers.nameStartsWith("javax."))
                        .or(ElementMatchers.nameStartsWith("aopalliance."))
                        .or(ElementMatchers.nameStartsWith("bsh."))
                        .or(ElementMatchers.nameStartsWith("ch.qos.logback."))
                        .or(ElementMatchers.nameStartsWith("com.alibaba."))
                        .or(ElementMatchers.nameStartsWith("com.aliyun."))
                        .or(ElementMatchers.nameStartsWith("com.taobao."))
                        .or(ElementMatchers.nameStartsWith("com.caucho."))
                        .or(ElementMatchers.nameStartsWith("com.dianping."))
                        .or(ElementMatchers.nameStartsWith("com.ea."))
                        .or(ElementMatchers.nameStartsWith("com.fasterxml."))
                        .or(ElementMatchers.nameStartsWith("com.netflix."))
                        .or(ElementMatchers.nameStartsWith("com.thoughtworks."))
                        .or(ElementMatchers.nameStartsWith("org.apache"))
                        .or(ElementMatchers.nameStartsWith("io.netty."))
                        .or(ElementMatchers.nameStartsWith("rx."))
                        .or(ElementMatchers.nameStartsWith("io."))
                        .or(ElementMatchers.nameStartsWith("feign."))
                        .or(ElementMatchers.nameStartsWith("springfox."))
                        .or(ElementMatchers.nameStartsWith("org.joda.time."))
                        .or(ElementMatchers.nameStartsWith("jline."))
                        .or(ElementMatchers.nameStartsWith("junit."))
                        .or(ElementMatchers.nameStartsWith("antlr.")))
                .type(pluginFinder.buildMatch()).transform(new AgentBuilder.Transformer() {
            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription,
                                                    ClassLoader classLoader, JavaModule module) {
                AbstractClassEnhancePluginDefine pluginDefine = pluginFinder.find(typeDescription, classLoader);
                if (pluginDefine != null) {
                    DynamicType.Builder<?> newBuilder = pluginDefine.define(typeDescription.getTypeName(), builder, classLoader);
                    if (newBuilder != null) {
                        if(logger.isInfoEnabled()) {
                            logger.info("Finish the prepare stage for " + typeDescription.getName());
                        }
                        return newBuilder;
                    }
                }

                logger.info("Matched class " + typeDescription.getTypeName() + ", but ignore by finding mechanism.");
                return builder;
            }
        }).with(new AgentBuilder.Listener() {
            @Override
            public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {

            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                         boolean loaded, DynamicType dynamicType) {
                if(logger.isInfoEnabled()) {
                    logger.info("On Transformation class " + typeDescription.getName());
                }
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                  boolean loaded) {

            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded,
                                Throwable throwable) {
                if(logger.isInfoEnabled() && !(throwable instanceof IllegalStateException && throwable.getMessage()!=null && throwable.getMessage().startsWith("Cannot resolve type description"))) {
                    logger.info("Failed to enhance class " + typeName, throwable);
                }
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            }
        }).installOn(instrumentation);

        installInstrumentation(instrumentation);
    }

    //设置到ByteBuddy里面，让后续调用 ByteBuddyAgent.install() 可以获得这个Instrumentation
    private static void installInstrumentation(Instrumentation instrumentation){
        try {
            Instrumentation ins = (Instrumentation) ClassLoader.getSystemClassLoader()
                    .loadClass(Installer.class.getName())
                    .getDeclaredField(INSTRUMENTATION_FIELD_NAME)
                    .get(null);
            if(ins == null){
                ClassLoader.getSystemClassLoader()
                        .loadClass(Installer.class.getName())
                        .getDeclaredField(INSTRUMENTATION_FIELD_NAME)
                        .set(null, instrumentation);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
