package cn.com.duibaboot.ext.autoconfigure.web.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;

public class SocketServerMuti {
    public static void main(String[] args) throws InterruptedException {
        try {
            ServerSocket serverSocket = new ServerSocket(8189,1);
            int i=0;
            while(true)
            {
                i++;
//                if( i > 1){
//                    break;
//                }
                Socket s = serverSocket.accept();
                Runnable t = new ThreadEchoHandler(s);
                new Thread(t).start();
            }
        } catch (IOException e) {
// TODO Auto-generated catch block
            e.printStackTrace();
        }


        Thread.sleep(10000000);
    }

}
class ThreadEchoHandler implements Runnable{
    private Socket s;
    private int cnt;
    private volatile static int count = 0;
    private synchronized static int addCount()
    {
        return count++;
    }

    public ThreadEchoHandler(Socket _s)
    {
        s = _s;
        cnt = addCount();
    }

    @Override
    public void run() {
        try {
            try{
                InputStream instream = s.getInputStream();
                OutputStream outstream = s.getOutputStream();
                Scanner in = new Scanner(instream);
                PrintWriter out = new PrintWriter(outstream, true /* autoFlush */);

                out.println( "Hello! You are "+cnt+" client! Enter BYE to exit.");

                // echo client input
                boolean done = false;
                while (!done && in.hasNextLine())
                {
                    String line = in.nextLine();
                    out.println("Echo: " + line);
                    if (line.trim().equals("BYE"))
                        done = true;
                }
            }
            finally
            {
                s.close();
            }
        } catch (IOException e) {
// TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
