/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.config;

import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdConfigProperties;
import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdPropertySourceLocator;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.stream.Collectors;
import mousio.etcd4j.EtcdClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EtcdEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        String uri = configurableEnvironment.getProperty("duiba.cloud.etcd.uris");
        if (!Strings.isNullOrEmpty((String)uri)) {
            try {
                EtcdConfigProperties etcdConfigProperties = new EtcdConfigProperties();
                URI[] list = Splitter.on((String)",").splitToList((CharSequence)uri).stream().map(URI::create).collect(Collectors.toList()).toArray(new URI[0]);
                EtcdClient etcdClient = new EtcdClient(list);
                EtcdPropertySourceLocator etcdPropertySourceLocator = new EtcdPropertySourceLocator(etcdClient, etcdConfigProperties);
                PropertySource<?> propertySource = etcdPropertySourceLocator.locate((Environment)configurableEnvironment);
                configurableEnvironment.getPropertySources().addLast(propertySource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

