/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.ttl.TransmittableExecutorBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.OnsPerfAspect;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import cn.com.duibaboot.ext.autoconfigure.perftest.RocketMqPerfAspect;
import cn.com.duibaboot.ext.autoconfigure.perftest.SpringDataMongodbPerfAspect;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.aliyun.openservices.ons.api.Consumer;
import com.mongodb.MongoClientURI;
import com.netflix.hystrix.HystrixCommand;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.hystrix.HystrixFeign;
import io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.core.rule.MasterSlaveRule;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
@ConditionalOnClass(value={TransmittableThreadLocal.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class PerfTestAutoConfiguration {
    @Bean
    public DiscoveryMetadataRegister perftest_DiscoveryMetadataRegister() {
        return new DiscoveryMetadataRegister(){

            @Override
            public void registerMetadata(Map<String, String> appMetadata) {
                appMetadata.put("isPerfTestSupportted", "1");
            }
        };
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
    public class PerfTestFeignConfiguration {
        @Bean
        public RequestInterceptor perfTestFeignRequestInterceptor() {
            return new RequestInterceptor(){

                public void apply(RequestTemplate template) {
                    if (PerfTestContext.isCurrentInPerfTestMode()) {
                        template.header("isPerfTestMode", new String[]{"true"});
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={MongoProperties.class, TransmittableThreadLocal.class})
    public static class MongoDbDataSourceConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestMongoDbDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<MongoProperties>(){

                public int getOrder() {
                    return -2;
                }

                @Override
                public Class<MongoProperties> getBeanType() {
                    return MongoProperties.class;
                }

                @Override
                public Object postProcessBeforeInitialization(MongoProperties bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(MongoProperties bean, String beanName) throws BeansException {
                    SpringDataMongodbPerfAspect.OriginDataBaseUri.put(new MongoClientURI(bean.getUri()).getDatabase(), bean.getUri());
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={AbstractRoutingDataSource.class, TransmittableThreadLocal.class})
    public static class DataSourceConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<DataSource>(){
                @Autowired
                Environment environment;

                public int getOrder() {
                    return -2;
                }

                @Override
                public Class<DataSource> getBeanType() {
                    return DataSource.class;
                }

                @Override
                public Object postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                    if (this.isBeanInstanceOfShardingJdbcDataSource(bean, beanName)) {
                        return bean;
                    }
                    if (!(bean instanceof PerfTestRoutingDataSource)) {
                        PerfTestRoutingDataSource ts = new PerfTestRoutingDataSource((DataSource)bean, this.environment);
                        ts.afterPropertiesSet();
                        bean = ts;
                    }
                    return bean;
                }
            };
        }

        private boolean isBeanInstanceOfShardingJdbcDataSource(DataSource bean, String beanName) {
            try {
                Class.forName("io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (!(bean instanceof AbstractDataSourceAdapter)) {
                return false;
            }
            if (bean instanceof ShardingDataSource) {
                ShardingDataSource ds = (ShardingDataSource)bean;
                Field field = ReflectionUtils.findField(ShardingDataSource.class, (String)"shardingContext");
                field.setAccessible(true);
                ShardingContext shardingContext = (ShardingContext)ReflectionUtils.getField((Field)field, (Object)ds);
                Map dataSourceMap = shardingContext.getShardingRule().getDataSourceMap();
                for (Map.Entry entry : dataSourceMap.entrySet()) {
                    DataSource innerDs = (DataSource)entry.getValue();
                    if (innerDs instanceof MasterSlaveDataSource) {
                        this.processMasterSlaveDataSource((DataSource)((MasterSlaveDataSource)innerDs), beanName);
                        continue;
                    }
                    if (innerDs instanceof PerfTestRoutingDataSource) continue;
                    this.onShardingJdbcError(beanName);
                }
            } else if (bean instanceof MasterSlaveDataSource) {
                this.processMasterSlaveDataSource((DataSource)((MasterSlaveDataSource)bean), beanName);
            } else {
                throw new IllegalStateException("[NOTIFYME]sharding jdbc\u65b0\u589e\u7684\u6570\u636e\u6e90\u6682\u65f6\u4e0d\u652f\u6301\uff0c\u5982\u9047\u5230\u6b64\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u67b6\u6784\u7ec4\u6dfb\u52a0\u652f\u6301");
            }
            return true;
        }

        private void processMasterSlaveDataSource(DataSource ds, String beanName) {
            MasterSlaveDataSource ds1 = (MasterSlaveDataSource)ds;
            MasterSlaveRule oriRule = ds1.getMasterSlaveRule();
            DataSource oriMd = oriRule.getMasterDataSource();
            boolean throwException = false;
            if (!(oriMd instanceof PerfTestRoutingDataSource)) {
                throwException = true;
            }
            if (!throwException) {
                Map slaveDataSourceMap = oriRule.getSlaveDataSourceMap();
                for (Map.Entry entry : slaveDataSourceMap.entrySet()) {
                    DataSource innerDs = (DataSource)entry.getValue();
                    if (innerDs instanceof PerfTestRoutingDataSource) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                this.onShardingJdbcError(beanName);
            }
        }

        private void onShardingJdbcError(String beanName) {
            throw new IllegalStateException("\u8bf7\u628aid\u4e3a[" + beanName + "]\u7684sharding-jdbc\u6570\u636e\u6e90\u5185\u90e8\u4f7f\u7528\u7684\u6570\u636e\u6e90\u6ce8\u518c\u4e3aspring\u7684bean\uff0c\u4ee5\u8ba9\u7ebf\u4e0a\u538b\u6d4b\u6846\u67b6\u6709\u673a\u4f1a\u5904\u7406\u5185\u90e8\u7684\u6570\u636e\u6e90\uff08\u5185\u90e8\u6570\u636e\u6e90\u5fc5\u987b\u4e3adbcp2\uff09");
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class, DefaultMQProducer.class, Aspect.class})
    public static class RocketMqPerfConfiguration {
        @Bean
        public RocketMqPerfAspect getRocketMqPerfAspect() {
            return new RocketMqPerfAspect();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class, Consumer.class, Aspect.class})
    public static class OnsPerfConfiguration {
        @Bean
        public OnsPerfAspect getOnsPerfAspect() {
            return new OnsPerfAspect();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class, MongoTemplate.class, Aspect.class})
    public static class SpringDataMongodbPerfConfiguration {
        @Bean
        public SpringDataMongodbPerfAspect getSpringDataMongodbPerfAspect() {
            return new SpringDataMongodbPerfAspect();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    public static class TransmittableThreadLocalConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestExecutorServiceBeanPostProcessor() {
            return new TransmittableExecutorBeanPostProcessor();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    @ConditionalOnWebApplication
    @Order(value=-2147483648)
    public static class WebConfiguration
    extends WebMvcConfigurerAdapter {
        public void addInterceptors(InterceptorRegistry registry) {
            try {
                Field field = registry.getClass().getDeclaredField("registrations");
                field.setAccessible(true);
                List registrations = (List)field.get(registry);
                for (InterceptorRegistration r : registrations) {
                    if (!(r instanceof InternalInterceptorRegistration)) continue;
                    return;
                }
                InternalInterceptorRegistration registration = new InternalInterceptorRegistration(this.pressureTestInterceptor());
                registration.addPathPatterns(new String[]{"/**"});
                if (registrations.isEmpty()) {
                    registrations.add(registration);
                } else {
                    registrations.add(0, registration);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private HandlerInterceptor pressureTestInterceptor() {
            return new HandlerInterceptorAdapter(){

                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
                    PerfTestContext._setPerfTestMode((Boolean)false);
                    boolean isTestMode = false;
                    String testInParameter = request.getParameter("_duibaPerf");
                    if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
                        isTestMode = true;
                    } else {
                        Cookie[] cookies = request.getCookies();
                        if (cookies != null) {
                            for (Cookie cookie : cookies) {
                                if (!"_duibaPerf".equals(cookie.getName()) || !"1".equals(cookie.getValue()) && !"true".equals(cookie.getValue())) continue;
                                isTestMode = true;
                            }
                        }
                    }
                    if (!isTestMode && "true".equals(request.getHeader("isPerfTestMode"))) {
                        isTestMode = true;
                    }
                    if (isTestMode) {
                        PerfTestContext._setPerfTestMode((Boolean)true);
                    }
                    return true;
                }

                public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
                    PerfTestContext._setPerfTestMode((Boolean)false);
                }
            };
        }

        private class InternalInterceptorRegistration
        extends InterceptorRegistration {
            public InternalInterceptorRegistration(HandlerInterceptor interceptor) {
                super(interceptor);
            }
        }
    }
}

