/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duiba.wolf.cache.XMemcacheClient;
import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.cat.CatDataSourcePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatHandlerInterceptor;
import cn.com.duibaboot.ext.autoconfigure.cat.CatMemcachePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatMybatisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatRediscachePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataHbaseAspect;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataMongodbPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SpringMvcConfigForCat;
import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransactionAspect;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.store.DataStore;
import com.alibaba.dubbo.registry.dubbo.DubboRegistry;
import com.dianping.cat.Cat;
import com.dianping.cat.servlet.CatFilter;
import com.dianping.cat.status.StatusExtension;
import com.dianping.cat.status.StatusExtensionRegister;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rubyeye.xmemcached.MemcachedClient;
import org.apache.catalina.startup.Tomcat;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import redis.clients.jedis.Jedis;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@Import(value={SpringMvcConfigForCat.class})
public class CatAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CatAutoConfiguration.class);
    private static final String ThreadPoolWaterLevelId = "\u7ebf\u7a0b\u6c60\u6c34\u4f4d\u56fe";

    @Bean
    @Conditional(value={CatCondition.class})
    public CatTransactionAspect catTransactionAspect() {
        return new CatTransactionAspect();
    }

    private static class CatCondition
    implements Condition {
        private CatCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return CatUtils.isCatEnabled();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={CatFilter.class})
    public static class DubiaBizThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    Initializable,
    ApplicationListener<ContextRefreshedEvent> {
        private ThreadPoolExecutorWrapper executorService;
        private ScheduledThreadPoolExecutorWrapper scheduledExecutorService;

        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u5404\u4e2a\u7ebf\u7a0b\u6c60\u7684\u6c34\u4f4d\u76d1\u63a7\u5fc3\u8df3";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            if (this.executorService != null) {
                maps.put("DuibaBiz-ActiveCount(core:" + this.executorService.getCorePoolSize() + ",max:" + this.executorService.getMaximumPoolSize() + ")", String.valueOf(this.executorService.getActiveCount()));
            }
            if (this.scheduledExecutorService != null) {
                maps.put("DuibaBizScheduled-ActiveCount(core:" + this.scheduledExecutorService.getCorePoolSize() + ",max:" + this.scheduledExecutorService.getMaximumPoolSize() + ")", String.valueOf(this.scheduledExecutorService.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() throws InitializationException {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            ApplicationContext applicationContext = event.getApplicationContext();
            try {
                Object executorService = applicationContext.getBean("executorService");
                if (executorService != null && executorService instanceof ThreadPoolExecutorWrapper) {
                    this.executorService = (ThreadPoolExecutorWrapper)executorService;
                }
            }
            catch (Exception executorService) {
                // empty catch block
            }
            try {
                Object scheduledExecutorService = applicationContext.getBean("scheduledExecutorService");
                if (scheduledExecutorService != null && scheduledExecutorService instanceof ScheduledThreadPoolExecutorWrapper) {
                    this.scheduledExecutorService = (ScheduledThreadPoolExecutorWrapper)scheduledExecutorService;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.executorService != null || this.scheduledExecutorService != null) {
                StatusExtensionRegister.getInstance().register((StatusExtension)this);
            }
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={TomcatEmbeddedServletContainerFactory.class, Tomcat.class, Servlet.class, CatFilter.class})
    public static class HttpThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    Initializable,
    ApplicationListener<EmbeddedServletContainerInitializedEvent> {
        private ThreadPoolExecutor httpThreadPool;

        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u5404\u4e2a\u7ebf\u7a0b\u6c60\u7684\u6c34\u4f4d\u76d1\u63a7\u5fc3\u8df3";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            if (this.httpThreadPool != null) {
                maps.put("Http-ActiveCount(core:" + this.httpThreadPool.getCorePoolSize() + ",max:" + this.httpThreadPool.getMaximumPoolSize() + ")", String.valueOf(this.httpThreadPool.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() throws InitializationException {
        }

        public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
            EmbeddedServletContainer c = event.getEmbeddedServletContainer();
            if (!(c instanceof TomcatEmbeddedServletContainer)) {
                return;
            }
            TomcatEmbeddedServletContainer container = (TomcatEmbeddedServletContainer)c;
            Executor es = container.getTomcat().getConnector().getProtocolHandler().getExecutor();
            if (!(es instanceof ThreadPoolExecutor)) {
                return;
            }
            this.httpThreadPool = (ThreadPoolExecutor)es;
            StatusExtensionRegister.getInstance().register((StatusExtension)this);
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={DubboRegistry.class, DataStore.class, CatFilter.class})
    public static class DubboThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    Initializable {
        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u5404\u4e2a\u7ebf\u7a0b\u6c60\u7684\u6c34\u4f4d\u76d1\u63a7\u5fc3\u8df3";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
            Map executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
            for (Map.Entry entry : executors.entrySet()) {
                String port = (String)entry.getKey();
                ExecutorService executor = (ExecutorService)entry.getValue();
                if (executor == null || !(executor instanceof ThreadPoolExecutor)) continue;
                ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
                String portStr = executors.size() == 1 ? "" : "port:" + port + ",";
                maps.put("Dubbo-ActiveCount(" + portStr + "core:" + tp.getCorePoolSize() + ",max:" + tp.getMaximumPoolSize() + ")", String.valueOf(tp.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() throws InitializationException {
            StatusExtensionRegister.getInstance().register((StatusExtension)this);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Cat.class})
    public static class InitCatServer
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        public void onApplicationEvent(ContextRefreshedEvent event) {
            CatInstance.isEnable();
        }

        public int getOrder() {
            return -3;
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={HbaseTemplate.class, HTable.class, Aspect.class})
    public static class CatHbaseConfiguration {
        @Bean
        public CatSpringDataHbaseAspect catSpringDataHbaseAspect() {
            return new CatSpringDataHbaseAspect();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={ElasticsearchOperations.class, Cat.class, Aspect.class})
    public static class CatElasticsearchConfiguration {
        @Bean
        public CatSpringDataElasticSearchPlugin getCatSpringDataElasticSearchPlugin() {
            return new CatSpringDataElasticSearchPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={MongoOperations.class, Cat.class, Aspect.class})
    public static class CatMongodbConfiguration {
        @Bean
        public CatSpringDataMongodbPlugin getCatSpringDataMongodbPlugin() {
            return new CatSpringDataMongodbPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={XMemcacheClient.class, MemcachedClient.class, Cat.class, Aspect.class})
    public static class CatMemcacheConfiguration {
        @Bean
        public CatMemcachePlugin getCatMemcachePlugin() {
            return new CatMemcachePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Cat.class, Aspect.class})
    @Conditional(value={CatCondition.class})
    public static class CatSpringDataRedisAspectConfiguration {
        @Bean
        public CatSpringDataRedisPlugin catSpringDataRedisAspectPlugin() {
            return new CatSpringDataRedisPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={RedisClient.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatRediscacheConfiguration {
        @Bean
        public CatRediscachePlugin getCatCachePlugin() {
            return new CatRediscachePlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    public static class CatDataSourcePluginConfiguration {
        @Bean
        public CatDataSourcePlugin getCatDataSourcePlugin() {
            return new CatDataSourcePlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, CatMybatisPlugin.class, Cat.class})
    public static class MyBatisPostProcessorConfiguration {
        @Bean
        public SpecifiedBeanPostProcessor myBatisPostProcessorConfigurer() {
            return new SpecifiedBeanPostProcessor<Object>(){

                public int getOrder() {
                    return -1;
                }

                @Override
                public Class<Object> getBeanType() {
                    return Object.class;
                }

                @Override
                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    SqlSessionFactory s = null;
                    if (bean instanceof SqlSessionFactory) {
                        s = (SqlSessionFactory)bean;
                    }
                    if (bean instanceof SqlSessionTemplate) {
                        s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
                    }
                    if (s == null) {
                        return bean;
                    }
                    boolean hasCatPlugin = false;
                    if (s.getConfiguration().getInterceptors() != null && !s.getConfiguration().getInterceptors().isEmpty()) {
                        for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                            if (!(plugin instanceof CatMybatisPlugin)) continue;
                            hasCatPlugin = true;
                            break;
                        }
                    }
                    if (!hasCatPlugin) {
                        s.getConfiguration().addInterceptor((Interceptor)new CatMybatisPlugin());
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, CatHandlerInterceptor.class, InterceptorRegistry.class})
    @ConditionalOnWebApplication
    @Conditional(value={CatCondition.class})
    @Order(value=-99)
    public static class CatHttpHandlerInterceptorConfiguration
    extends WebMvcConfigurerAdapter {
        public void addInterceptors(InterceptorRegistry registry) {
            CatHandlerInterceptor chi = new CatHandlerInterceptor(){

                @Override
                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                    if ("true".equals(request.getHeader("X-Rpc"))) {
                        return true;
                    }
                    return super.preHandle(request, response, handler);
                }
            };
            registry.addInterceptor((HandlerInterceptor)chi);
            super.addInterceptors(registry);
        }
    }
}

