/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(value={"duiba.server.internal-mode"}, havingValue="false", matchIfMissing=true)
public class WebMvcCspReportAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcCspReportAutoConfiguration.class);

    public static class CspReportFilter
    implements Filter {
        private static final Logger cspReportLogger = LoggerFactory.getLogger((String)"duibaCspReportLog");

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            String uri;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if (cspReportLogger.isInfoEnabled() && (uri = RequestUtils.getRequestPath((HttpServletRequest)request)).equals("/csp/report") && request.getMethod().equalsIgnoreCase("POST")) {
                String json = IOUtils.toString((InputStream)request.getInputStream());
                cspReportLogger.info(json);
            }
        }

        public void destroy() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
    @ConditionalOnProperty(value={"duiba.server.internal-mode"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnWebApplication
    public static class CspReportFilterConfiguration {
        @Bean
        public FilterRegistrationBean cspReportFilterConfigurer() {
            CspReportFilter filter = new CspReportFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/csp/report");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(Integer.MIN_VALUE);
            return registrationBean;
        }
    }
}

