package cn.com.duibaboot.ext.autoconfigure.logger.logback;

import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import cn.com.duiba.boot.perftest.PerfTestContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

/**
 * 在线程名后面附加Perf标记，表示当前线程在压测
 * <br/>
 * 在线程名后面附加sleuth分布式追踪的相关信息:tradeId,spanId,exportable
 */
public class ThreadAndPerfTestConverter extends ThreadConverter {
    @Override
    public String convert(ILoggingEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.convert(event));
        if(!PerfTestContext.isCurrentInPerfTestMode()) {
//            sb.append(":NoPerf");
        }else{
            //在线程名后面附加Perf标记，表示当前线程在压测
            sb.append(":Perf");
        }

        //在线程名后面附加sleuth分布式追踪的相关信息:tradeId,spanId,exportable
        //相当于把[%thread]  转为如下格式： [%thread,%X{X-B3-TraceId:-},%X{X-B3-SpanId:-},%X{X-Span-Export:-}]
        sb.append(",").append(StringUtils.trimToEmpty(MDC.get("X-B3-TraceId")));
        sb.append(",").append(StringUtils.trimToEmpty(MDC.get("X-B3-SpanId")));
        sb.append(",").append(StringUtils.trimToEmpty(MDC.get("X-Span-Export")));

        return sb.toString();
    }
}
