package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransaction;
import org.apache.rocketmq.client.consumer.listener.*;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;

/**
 * RocketMQ MessageListener的包装，增加cat监控
 */
public class MessageListenerOrderlyWrapper implements MessageListenerOrderly {

    private MessageListenerOrderly source;

    public MessageListenerOrderlyWrapper(MessageListenerOrderly source){
        this.source = source;
    }

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.consume")
    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        DBTimeProfile.start();
        try {
            return source.consumeMessage(msgs, context);
        }finally {
            DBTimeProfile.end("RocketMQ.consume");
        }
    }
}
