/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd.cloud;

import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdConfigProperties;
import cn.com.duibaboot.ext.autoconfigure.initserver.MainApplicationContextHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mousio.client.ConnectionState;
import mousio.client.retry.RetryPolicy;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdHealthResponse;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class EtcdPropertySource
extends EnumerablePropertySource<EtcdClient> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdPropertySource.class);
    private final Map<String, String> properties = new HashMap<String, String>();
    private final String prefix;
    private final EtcdConfigProperties config;

    public EtcdPropertySource(String root, EtcdClient source, EtcdConfigProperties config) {
        super(root, (Object)source);
        this.prefix = root.startsWith("/") ? root + "/" : "/" + root + "/";
        this.config = config;
    }

    private void asyncRetry() {
        final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ContextRefresher contextRefresher;
                Thread.currentThread().setName("etcd-refresh");
                EtcdHealthResponse healthResponse = ((EtcdClient)EtcdPropertySource.this.getSource()).getHealth();
                ApplicationContext applicationContext = MainApplicationContextHolder.getApplicationContext();
                if ("true".equals(healthResponse.getHealth()) && applicationContext != null && (contextRefresher = (ContextRefresher)applicationContext.getBean(ContextRefresher.class)) != null) {
                    contextRefresher.refresh();
                    executorService.shutdown();
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public void init() {
        try {
            EtcdKeysResponse response = (EtcdKeysResponse)((EtcdClient)this.getSource()).getDir(this.getName()).recursive().timeout((long)this.config.getTimeout(), this.config.getTimeoutUnit()).setRetryPolicy(new RetryPolicy(0){

                public boolean shouldRetry(ConnectionState connectionState) {
                    if (connectionState.retryCount <= 1) {
                        return true;
                    }
                    EtcdPropertySource.this.asyncRetry();
                    return false;
                }
            }).send().get();
            if (response.node != null) {
                this.process(response.node);
            }
        }
        catch (EtcdException e) {
            if (e.errorCode == 100) {
                logger.debug("Unable to init property source: " + this.getName() + ", " + e.getMessage());
            } else {
                logger.warn("Unable to init property source: " + this.getName(), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to init property source: " + this.getName(), (Throwable)e);
        }
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void process(EtcdKeysResponse.EtcdNode root) {
        if (!StringUtils.isEmpty((Object)root.value)) {
            String key = root.key.substring(this.prefix.length());
            this.properties.put(key.replace("/", "."), root.value);
        }
        if (!CollectionUtils.isEmpty((Collection)root.nodes)) {
            for (EtcdKeysResponse.EtcdNode node : root.nodes) {
                this.process(node);
            }
        }
    }
}

