package cn.com.duibaboot.ext.autoconfigure.core.utils;

import com.alibaba.fastjson.JSONObject;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.validation.DataBinder;

import java.util.HashMap;
import java.util.Map;

/**
 * 配置解析工具
 */
public class PropertyResolver {

    private final String prefix;

    private final PropertySources propertySources;

    public PropertyResolver(AbstractEnvironment environment, String prefix) {
        this.propertySources = environment.getPropertySources();
        this.prefix = prefix;
    }

    /**
     * 将配置数据绑定到Map中
     * @param json
     */
    public void bindToJson(JSONObject json){
        DataBinder binder = new RelaxedDataBinder(json,this.prefix);
        binder.bind(new PropertySourcesPropertyValues(propertySources));
    }

    /**
     * 将配置绑定到对象中
     * @param config
     */
    public void bindToConfig(Object config){
        DataBinder binder = new RelaxedDataBinder(config,this.prefix);
        binder.bind(new PropertySourcesPropertyValues(propertySources));
    }



}
