package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * eurekaClient实例在 @ConditionalOnRefreshScope 情况下每次 refresh，会销毁重新创建。实例会取消注册，再重新注册到eureka。导致其他应用从eureka获取该应用实例的时候存在找不到的情况
 * 此处扩展后，refresh不再会重新创建eurekaClient实例
 * Created by gyf .
 * 2018/4/27 .
 */
@Configuration
public class EurekaClientPostProcessorAutoConfiguration {

    //BeanDefinitionRegistryPostProcessor的声明必须是static的
    @Bean
    public static EurekaClientBeanDefinitionRegistryPostProcessor eurekaClientBeanDefinitionRegistryPostProcessor() {
        return new EurekaClientBeanDefinitionRegistryPostProcessor();
    }
}
