package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.cloud.netflix.feign.CustomFeignClientsRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

import java.util.Set;

@Configuration
@ConditionalOnClass(Hystrix.class)
public class HystrixAutoConfiguration {

    //这里暂时没用，这个类实际上是被hystrix使用spi引入的（spring Security中会被拿到进行包装）
    @Bean
    public HystrixConcurrencyStrategy getHystrixConcurrencyStrategy(){
        return new CustomHystrixConcurrencyStrategy();
    }

    /**
     * 初始化Hystrix（进行一次Hystrix调用）。以防止启动后第一次调用很慢的问题。
     * @return
     */
    @Bean
    public ApplicationListener HystrixInitListener(){
        return new ApplicationListener<ContextRefreshedEvent>() {
            @Override
            public void onApplicationEvent(ContextRefreshedEvent event) {
                if(event.getApplicationContext() instanceof EmbeddedWebApplicationContext) {//只在主ApplicationContext中运行
                    Set<String> enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
                    if(!enabledFeignClientNames.isEmpty()){
//                        String anyfeignClientName = enabledFeignClientNames.iterator().next();
                        String anyfeignClientName = "bootInit";
                        HystrixCommand<String> command = new HystrixCommand<String>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey(anyfeignClientName))
                                .andCommandKey(HystrixCommandKey.Factory.asKey("bootInit"))) {
                            @Override
                            protected String run() throws Exception {
                                //do nothing
                                return null;
                            }
                        };
                        command.execute();
                    }
                }
            }
        };
    }
}
