package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon

import cn.com.duiba.boot.netflix.ribbon.RibbonServerPredicate
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataAutoConfiguration
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer

/**
 * ribbon列表过滤器,用于控制docker中的应用优先调用docker应用，vm中的应用优先调用vm中的应用，（docker应用如果没有找到则会调用vm中的应用，vm中的也一样）
 */
data class DockerOrVmRibbonServerPredicate(var isCurrentRunInDocker: Boolean): RibbonServerPredicate {
    override fun test(t: DiscoveryEnabledServer?): Boolean {
        var runInDocker = t?.instanceInfo?.metadata?.get(DiscoveryMetadataAutoConfiguration.RUN_IN_DOCKER)
        var runInDockerBol: Boolean = "true".equals(runInDocker)
        return isCurrentRunInDocker.equals(runInDockerBol)
    }
}
